/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.quality_report.QualityArtifactParameters;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.SlideRenderDataBase;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.ESlideOptionType;
import com.teamscale.index.quality_report.slides.IImageUsingSlide;
import com.teamscale.index.quality_report.slides.SlideParameter;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass(containedInBackup=true)
public class TitleSlide
extends ReportSlideBase<TitleSlideParameters, TitleSlideResult>
implements IImageUsingSlide {
    private static final long serialVersionUID = 1L;

    public TitleSlide() {
    }

    public TitleSlide(String id, String title, String subTitle) {
        this.setId(id);
        TitleSlideParameters slideParameters = new TitleSlideParameters();
        slideParameters.setTitle(title);
        slideParameters.setSubTitles(subTitle);
        this.setSlideParameters(slideParameters);
    }

    @Override
    public EReportSlide getSlideType() {
        return EReportSlide.TITLE;
    }

    @Override
    public void reset(QualityArtifactParameters report, boolean fromTemplate) {
        super.reset(report, fromTemplate);
        ((TitleSlideParameters)this.getSlideParameters()).setTitle(report.name());
    }

    @Override
    public List<String> getUsedImageIds() {
        return Arrays.asList(((TitleSlideParameters)this.getSlideParameters()).getCompanyLogoId(), ((TitleSlideParameters)this.getSlideParameters()).getHeaderImageId());
    }

    @IndexValueClass(containedInBackup=true)
    public static class TitleSlideParameters
    extends SlideParametersBase {
        private static final long serialVersionUID = 1L;
        @VisibleForTesting
        public static final String DEFAULT_TITLE_COVER_STRIP = "images/reports/report-cover-strip.jpg";
        @VisibleForTesting
        public static final String DEFAULT_TITLE_CQSE_LOGO = "images/reports/cqse-logo.png";
        @JsonProperty(value="title")
        @SlideParameter(formattedName="Presentation Title", inputHint="Markdown supported", type=ESlideOptionType.MULTILINE_STRING)
        private String title;
        @JsonProperty(value="subTitles")
        @SlideParameter(formattedName="Subtitles", inputHint="Markdown supported", type=ESlideOptionType.MULTILINE_STRING)
        private String subTitles;
        @JsonProperty(value="headerImageId")
        @SlideParameter(formattedName="Banner Image", inputHint="", type=ESlideOptionType.IMAGE_UPLOAD)
        private String headerImageId = "images/reports/report-cover-strip.jpg";
        @JsonProperty(value="companyLogoId")
        @SlideParameter(formattedName="Company Logo", inputHint="", type=ESlideOptionType.IMAGE_UPLOAD)
        private String companyLogoId = "images/reports/cqse-logo.png";

        @Override
        public List<PublicProjectId> getReferencedProjects() {
            return Collections.emptyList();
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setSubTitles(String subTitles) {
            this.subTitles = subTitles;
        }

        public String getHeaderImageId() {
            return this.headerImageId;
        }

        public String getCompanyLogoId() {
            return this.companyLogoId;
        }

        public String getTitle() {
            return this.title;
        }
    }

    @ExportToTypeScript
    public static enum ETitleSlidePlaceholders {
        START_DATE("{start_date}"),
        END_DATE("{end_date}"),
        START_BASELINE_NAME("{start_name}"),
        END_BASELINE_NAME("{end_name}"),
        PROJECT_NAME("{project_name}"),
        REPORT_CREATION_DATE("{report_creation_date}");

        private final String placeholder;

        private ETitleSlidePlaceholders(String placeholder) {
            this.placeholder = placeholder;
        }

        public String toString() {
            return this.placeholder;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class TitleSlideResult
    extends SlideRenderDataBase {
        private static final long serialVersionUID = 1L;
        private static final String HEADER_IMAGE_URL_PROPERTY = "headerImageUrl";
        private static final String COMPANY_LOGO_URL_PROPERTY = "companyLogoUrl";
        @JsonProperty(value="headerImageUrl")
        public final String headerImageUrl;
        @JsonProperty(value="companyLogoUrl")
        public final String companyLogoUrl;

        @JsonCreator
        public TitleSlideResult(@JsonProperty(value="headerImageUrl") String headerImageUrl, @JsonProperty(value="companyLogoUrl") String companyLogoUrl) {
            this.headerImageUrl = headerImageUrl;
            this.companyLogoUrl = companyLogoUrl;
        }
    }
}

