/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage;

import com.teamscale.index.report.coverage.CoverageReportParserInvokerBase;
import com.teamscale.index.resource.path_lookup.IPathMatchingPlausibilityCheck;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;

public abstract class ClassNameMatchingCoverageReportParserInvokerBase
extends CoverageReportParserInvokerBase {
    private static final String FILE_AND_TYPE_NOT_FOUND_MARKER = "file-and-type-not-found";
    private static final String TYPE_NOT_FOUND_MARKER = "type-not-found";
    private static final String MULTIPLE_MATCHING_UNIFORM_PATHS_MARKER = "multiple-matching-uniform-paths";
    private static final List<ELanguage> PATH_BASED_HANDLED_LANGUAGES = Arrays.asList(ELanguage.KOTLIN, ELanguage.GOSU);
    private ListMap<String, String> typeFileLookupMap;

    @Override
    protected CoverageInfoRetriever createCoverageInfoRetriever() {
        return new CoverageInfoRetriever(true);
    }

    private static boolean shouldHandleTypeBased(String fileName) {
        return Collections.disjoint(ELanguage.getAllLanguagesForPath((String)fileName), PATH_BASED_HANDLED_LANGUAGES);
    }

    @Override
    protected Optional<String> resolvePath(String pathFromReport, IPathMatchingPlausibilityCheck plausibilityCheck, String pathPrefix) throws StorageException {
        Optional<String> result;
        if (ClassNameMatchingCoverageReportParserInvokerBase.shouldHandleTypeBased(pathFromReport)) {
            List uniformPaths;
            String fullQualifiedClassName = ClassNameMatchingCoverageReportParserInvokerBase.convertToFullyQualifiedClassName(pathFromReport);
            if (this.typeFileLookupMap == null) {
                CCSMAssert.isNotNull((Object)this.typeIndexCache);
                this.typeFileLookupMap = this.typeIndexCache.getTypeFileLookupMap();
            }
            if (!CollectionUtils.isNullOrEmpty((Collection)(uniformPaths = (List)this.typeFileLookupMap.getCollection((Object)fullQualifiedClassName)))) {
                String bestMatchingPath = this.getBestMatchingPath(fullQualifiedClassName, uniformPaths, pathPrefix);
                return Optional.of(bestMatchingPath);
            }
            LOGGER.atLevel((Level)this.loggingRateLimiting.applyLimit((Object)TYPE_NOT_FOUND_MARKER, (Object)Level.WARN, (Object)Level.DEBUG, () -> LOGGER.warn("Reduced similar log messages. Turn on debug logging to see all."))).log("Could not find a matching type for '{}' and report path '{}'. Falling back to path matching.", (Object)fullQualifiedClassName, (Object)pathFromReport);
        }
        if ((result = super.resolvePath(pathFromReport, plausibilityCheck, pathPrefix)).isEmpty()) {
            LOGGER.atLevel((Level)this.loggingRateLimiting.applyLimit((Object)FILE_AND_TYPE_NOT_FOUND_MARKER, (Object)Level.WARN, (Object)Level.DEBUG, () -> LOGGER.warn("Reduced similar log messages. Turn on debug logging to see all."))).log("Could neither find a file that contains a type called {}, nor a file with a uniform path matching {}", (Object)ClassNameMatchingCoverageReportParserInvokerBase.convertToFullyQualifiedClassName(pathFromReport), (Object)pathFromReport);
        }
        return result;
    }

    private static @NonNull String convertToFullyQualifiedClassName(String pathFromReport) {
        return StringUtils.removeLastPart((String)pathFromReport, (char)'.').replace('/', '.');
    }

    private String getBestMatchingPath(String fullQualifiedClassName, List<String> possiblePaths, @Nullable String pathPrefix) {
        List<String> filteredPaths = new ArrayList<String>(possiblePaths);
        if (pathPrefix != null) {
            filteredPaths = CollectionUtils.filter(filteredPaths, path -> path.startsWith(pathPrefix));
        }
        if (filteredPaths.size() > 1) {
            filteredPaths.sort(Comparator.comparing(String::length));
            String message = "Multiple matching uniform paths for: " + fullQualifiedClassName + " (choosing first):\n" + StringUtils.concat(filteredPaths.subList(0, 2), (String)"\n");
            if (filteredPaths.size() > 2) {
                message = message + "\n...";
            }
            LOGGER.atLevel((Level)this.loggingRateLimiting.applyLimit((Object)MULTIPLE_MATCHING_UNIFORM_PATHS_MARKER, (Object)Level.WARN, (Object)Level.DEBUG, () -> LOGGER.warn("Reduced similar log messages. Turn on debug logging to see all."))).log(message);
        }
        return filteredPaths.get(0);
    }
}

