/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage.bullseye;

import com.teamscale.index.dataflow.CFGConstructor;
import com.teamscale.index.dataflow.CfgConstructorResult;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowHeuristicFactory;
import com.teamscale.index.report.coverage.bullseye.BullseyeReportHandler;
import com.teamscale.index.report.coverage.bullseye.BullseyeSimpleHeuristicStrategy;
import com.teamscale.index.report.coverage.bullseye.BullseyeStrategyBase;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.graph.GraphDebuggingUtils;
import org.conqat.lib.commons.visitor.IMeshWalker;

public class BullseyeCFGStrategy
extends BullseyeStrategyBase {
    private Map<IToken, ShallowEntity> entityByLineAndOffset = new HashMap<IToken, ShallowEntity>();
    private final BullseyeSimpleHeuristicStrategy fallbackStrategy;

    public BullseyeCFGStrategy(BullseyeReportHandler reportHandler, CoverageInfoRetriever lineCoverageInfoRetriever) {
        super(reportHandler, lineCoverageInfoRetriever);
        this.fallbackStrategy = new BullseyeSimpleHeuristicStrategy(reportHandler, lineCoverageInfoRetriever);
    }

    @Override
    protected void importCoverage(String file, String uniformPath, TokenElementInfo fileElement, TokenElementLineInfo tokenElementLineInfo) throws ConQATException {
        Map<String, CfgConstructorResult> cfgConstructorResults = BullseyeCFGStrategy.constructCFG(fileElement);
        CfgConstructorResult pathResult = cfgConstructorResults.get(uniformPath);
        if (pathResult == null || pathResult.getGraphs().isEmpty() && !pathResult.getEntities().isEmpty()) {
            LOGGER.warn(String.format("No CFG for path '%s'. Falling back to old coverage heuristic.", uniformPath));
            this.fallbackStrategy.importCoverage(file, uniformPath, fileElement, tokenElementLineInfo);
            return;
        }
        List<ControlFlowGraph> graphs = pathResult.getGraphs();
        LineCoverageInfo lineCoverageInfo = this.lineCoverageInfoRetriever.getOrCreateLineCoverageInfo(uniformPath);
        lineCoverageInfo.setCoverableLines(tokenElementLineInfo.getRawCoverableLines());
        this.entityByLineAndOffset = BullseyeCFGStrategy.mapEntitiesByTokenValues(fileElement);
        for (ControlFlowGraph graph : graphs) {
            try {
                this.processGraph(graph, file, lineCoverageInfo);
            }
            catch (AssertionError | Exception exception) {
                LOGGER.warn(String.format("Importing coverage for method '%s' in '%s' failed. Using fallback.", graph.getMethodName(), uniformPath), (Throwable)exception);
                LOGGER.debug(GraphDebuggingUtils.getDotString((Object)graph.getRoot(), ControlFlowNode::getId, (IMeshWalker[])new IMeshWalker[]{ControlFlowNode.LAMBDA_WALKER}));
                this.fallbackStrategy.importCoverageForEntities(file, uniformPath, graph.getEntities());
            }
        }
    }

    private static Map<String, CfgConstructorResult> constructCFG(TokenElementInfo element) throws ConQATException {
        try {
            if (!ShallowParserFactory.supportsLanguage((ELanguage)element.getLanguage()) || !DataFlowHeuristicFactory.supportsLanguage(element.getLanguage())) {
                return Map.of(element.getUniformPath(), new CfgConstructorResult(List.of(), List.of()));
            }
            UnmodifiableList<ShallowEntity> entities = element.getShallowEntitiesWithPreprocessorTokens();
            List<ControlFlowGraph> graphs = CFGConstructor.getControlFlowGraphs(element.getLanguage(), element.getUniformPath(), entities, true);
            return Map.of(element.getUniformPath(), new CfgConstructorResult((List<ShallowEntity>)entities, graphs));
        }
        catch (ConQATException e) {
            LOGGER.error(e.toString(), (Throwable)e);
            throw new ConQATException("Could not construct CFG for bullseye report parsing for element: " + element.getUniformPath(), (Throwable)e);
        }
    }

    private static Map<IToken, ShallowEntity> mapEntitiesByTokenValues(TokenElementInfo tokenElementInfo) {
        List<ShallowEntity> selectedEntities = BullseyeCFGStrategy.selectEntities(tokenElementInfo.getShallowEntitiesWithPreprocessorTokens());
        HashMap<IToken, ShallowEntity> result = new HashMap<IToken, ShallowEntity>();
        for (ShallowEntity entity : selectedEntities) {
            entity.ownTokens().stream().flatMap(Collection::stream).forEach(token -> {
                if (!result.containsKey(token) || entity.equals(((ShallowEntity)result.get(token)).getParent())) {
                    result.put((IToken)token, entity);
                }
            });
        }
        return result;
    }

    private void processGraph(ControlFlowGraph graph, String file, LineCoverageInfo lineCoverageInfo) {
        if (!this.processMethodHeader(graph, file, lineCoverageInfo)) {
            return;
        }
        HashSet<ControlFlowNode> visitedGraphNodes = new HashSet<ControlFlowNode>();
        LinkedList<ControlFlowNode> worklist = new LinkedList<ControlFlowNode>();
        worklist.add(graph.getRoot());
        while (!worklist.isEmpty()) {
            ControlFlowNode work = (ControlFlowNode)worklist.pop();
            if (!visitedGraphNodes.add(work)) continue;
            worklist.addAll(this.processGraphNode(lineCoverageInfo, file, work));
        }
    }

    private boolean processMethodHeader(ControlFlowGraph graph, String file, LineCoverageInfo lineCoverageInfo) {
        boolean hasCoveredRootEntity = false;
        for (ShallowEntity rootEntity : graph.getEntities()) {
            BullseyeReportHandler.Probe probe = this.reportHandler.getProbe(file, rootEntity);
            if (probe == null) continue;
            hasCoveredRootEntity = probe.getProbeEvent() != BullseyeReportHandler.EProbeEvent.NONE;
            BullseyeCFGStrategy.addLineCoverageWithProbe(rootEntity, probe, lineCoverageInfo);
        }
        return hasCoveredRootEntity;
    }

    private List<ControlFlowNode> processGraphNode(LineCoverageInfo coverageReceiver, String file, @NonNull ControlFlowNode node) {
        Boolean blockEntered;
        ShallowEntity entity = this.getEntityForNode(node);
        if (entity == null) {
            return node.getSuccessors();
        }
        ArrayList<ControlFlowNode> proceedFrom = new ArrayList<ControlFlowNode>();
        BullseyeReportHandler.Probe probe = this.reportHandler.getProbe(file, entity);
        if (probe != null && probe.getProbeEvent() == BullseyeReportHandler.EProbeEvent.NONE) {
            return proceedFrom;
        }
        if (probe == null && !node.isConditional() && (blockEntered = this.reportHandler.getBlockWasEntered(file, entity)) != null && !blockEntered.booleanValue()) {
            return proceedFrom;
        }
        List<ControlFlowNode> switchNodes = this.processSwitch(coverageReceiver, file, node, entity, probe);
        proceedFrom.addAll(switchNodes);
        List<ControlFlowNode> lambdaNodes = this.processLambdas(coverageReceiver, file, node);
        proceedFrom.addAll(lambdaNodes);
        return proceedFrom;
    }

    private List<ControlFlowNode> processLambdas(LineCoverageInfo coverageReceiver, String file, @NonNull ControlFlowNode node) {
        if (node.hasLambdas()) {
            return node.getLambdas().stream().filter(lambda -> this.processMethodHeader((ControlFlowGraph)lambda, file, coverageReceiver)).map(ControlFlowGraph::getRoot).toList();
        }
        return CollectionUtils.emptyList();
    }

    private List<ControlFlowNode> processSwitch(LineCoverageInfo coverageReceiver, String file, @NonNull ControlFlowNode node, ShallowEntity entity, BullseyeReportHandler.Probe probe) {
        if (BullseyeCFGStrategy.isSwitchHead(node)) {
            return this.handleSwitchGraphNode(node, entity, file, coverageReceiver);
        }
        if (node.isConditional()) {
            return this.handleConditionalGraphNode(node, entity, probe, coverageReceiver);
        }
        if (node.getSuccessors().size() > 1) {
            return BullseyeCFGStrategy.handleMultiSuccessorNode(node, entity, probe, coverageReceiver);
        }
        return BullseyeCFGStrategy.handleNonConditionalGraphNode(node, entity, probe, coverageReceiver);
    }

    private static List<ControlFlowNode> handleMultiSuccessorNode(ControlFlowNode node, ShallowEntity entity, BullseyeReportHandler.Probe probe, LineCoverageInfo coverageReceiver) {
        if (probe == null) {
            probe = new BullseyeReportHandler.Probe(entity.getStartLine(), BullseyeReportHandler.EProbeKind.DECISION, BullseyeReportHandler.EProbeEvent.FULL);
        }
        BullseyeCFGStrategy.addLineCoverageWithProbe(entity, probe, coverageReceiver);
        return node.getSuccessors();
    }

    private List<ControlFlowNode> handleSwitchGraphNode(ControlFlowNode switchNode, ShallowEntity switchEntity, String file, LineCoverageInfo lineCoverageInfo) {
        ArrayList<ControlFlowNode> proceedFrom = new ArrayList<ControlFlowNode>();
        CCSMAssert.isTrue((boolean)BullseyeCFGStrategy.isSwitchHead(switchNode), (String)"Assuming to be executed on a switch node");
        Map<ControlFlowNode, ShallowEntity> caseMapping = this.buildCaseMapping(switchNode, switchEntity);
        int numberOfCases = 0;
        int numberCoveredCases = 0;
        for (int i = 0; i < switchNode.getSuccessors().size(); ++i) {
            ControlFlowNode successorNode = switchNode.getSuccessors().get(i);
            ShallowEntity caseEntity = caseMapping.get(successorNode);
            boolean proceedInCase = true;
            if (caseEntity != null) {
                BullseyeReportHandler.Probe caseProbe = this.reportHandler.getProbe(file, caseEntity);
                ++numberOfCases;
                if (caseProbe != null && caseProbe.getProbeEvent() == BullseyeReportHandler.EProbeEvent.NONE) {
                    BullseyeCFGStrategy.addLineCoverage(lineCoverageInfo, caseEntity, ELineCoverage.NOT_COVERED);
                    proceedInCase = false;
                } else if (caseProbe != null) {
                    ++numberCoveredCases;
                    BullseyeCFGStrategy.addLineCoverageWithProbe(caseEntity, caseProbe, lineCoverageInfo);
                }
            }
            if (successorNode.isSynthetic() || !proceedInCase) continue;
            proceedFrom.add(successorNode);
        }
        BullseyeReportHandler.EProbeEvent event = numberCoveredCases == 0 ? BullseyeReportHandler.EProbeEvent.NONE : (numberCoveredCases < numberOfCases ? BullseyeReportHandler.EProbeEvent.TRUE : BullseyeReportHandler.EProbeEvent.FULL);
        BullseyeCFGStrategy.addLineCoverageWithProbe(switchEntity, new BullseyeReportHandler.Probe(switchEntity.getStartLine(), BullseyeReportHandler.EProbeKind.DECISION, event), lineCoverageInfo);
        return proceedFrom;
    }

    private Map<ControlFlowNode, ShallowEntity> buildCaseMapping(ControlFlowNode switchNode, ShallowEntity switchEntity) {
        CCSMAssert.isTrue((boolean)switchEntity.getSubtype().equals("switch"), (String)String.format("Assuming given `switchEntity` to be a switch statement but is '%s': %s", switchEntity.getSubtype(), switchEntity));
        HashMap<ShallowEntity, ShallowEntity> hasCaseLabel = new HashMap<ShallowEntity, ShallowEntity>();
        ArrayList<ShallowEntity> unassignedEntities = new ArrayList<ShallowEntity>();
        for (int i = switchEntity.getChildren().size() - 1; i >= 0; --i) {
            ShallowEntity entity = (ShallowEntity)switchEntity.getChildren().get(i);
            if (entity.getType() == EShallowEntityType.META && (entity.getSubtype().equals("case") || entity.getSubtype().equals("default"))) {
                for (ShallowEntity unassigned : unassignedEntities) {
                    hasCaseLabel.put(unassigned, entity);
                }
                unassignedEntities.clear();
                continue;
            }
            unassignedEntities.add(entity);
        }
        Map<ControlFlowNode, ShallowEntity> result = this.getSwitchTargets(switchNode, switchEntity, hasCaseLabel);
        BullseyeCFGStrategy.determineCaseNodesForPredecessors(switchNode.getSuccessors(), result, hasCaseLabel);
        return result;
    }

    private static void determineCaseNodesForPredecessors(List<ControlFlowNode> successors, Map<ControlFlowNode, ShallowEntity> result, Map<ShallowEntity, ShallowEntity> hasCaseLabel) {
        LinkedList<ControlFlowNode> worklist = new LinkedList<ControlFlowNode>(successors);
        while (!worklist.isEmpty()) {
            ControlFlowNode work = (ControlFlowNode)worklist.pop();
            if (BullseyeCFGStrategy.isSwitchHead(work)) continue;
            ShallowEntity workCase = result.get(work);
            List<ControlFlowNode> predNodes = work.getPredecessors().stream().filter(ControlFlowNode::isSynthetic).toList();
            if (workCase == null || predNodes.size() != 1) continue;
            ControlFlowNode predNode = predNodes.getFirst();
            ShallowEntity predCaseEntity = hasCaseLabel.get(workCase);
            CCSMAssert.isNotNull((Object)predCaseEntity);
            result.put(predNode, predCaseEntity);
            worklist.add(predNode);
        }
    }

    private Map<ControlFlowNode, ShallowEntity> getSwitchTargets(ControlFlowNode switchNode, ShallowEntity switchEntity, Map<ShallowEntity, ShallowEntity> hasCaseLabel) {
        HashMap<ControlFlowNode, ShallowEntity> result = new HashMap<ControlFlowNode, ShallowEntity>();
        for (ControlFlowNode successor : switchNode.getSuccessors()) {
            ShallowEntity caseEntity;
            ShallowEntity successorEntity;
            if (successor.getTokens().isEmpty() || switchEntity.getEndOffset() < successor.getTokens().getFirst().getOffset() || (successorEntity = this.mapToSingleShallowEntityWithParentSubtype(successor, "switch")) == null || (caseEntity = hasCaseLabel.get(successorEntity)) == null) continue;
            result.put(successor, caseEntity);
        }
        return result;
    }

    private @Nullable ShallowEntity mapToSingleShallowEntityWithParentSubtype(ControlFlowNode successor, String expectedParentSubType) {
        Set<ShallowEntity> successorEntities = this.mapToShallowEntities(successor, entity -> entity.getParent() != null && expectedParentSubType.equals(entity.getParent().getSubtype()) && EShallowEntityType.META != entity.getType());
        CCSMAssert.isTrue((successorEntities.size() <= 1 ? 1 : 0) != 0, (String)("Expecting the case tokens to match at most 1 shallow entity. Matched instead to " + successorEntities.size() + " entities. Faulty node: " + String.valueOf(successor)));
        if (successorEntities.isEmpty()) {
            return null;
        }
        return successorEntities.iterator().next();
    }

    private @NonNull Set<ShallowEntity> mapToShallowEntities(ControlFlowNode node, Predicate<ShallowEntity> filterCondition) {
        return node.getTokens().stream().map(this.entityByLineAndOffset::get).filter(Objects::nonNull).filter(filterCondition).collect(Collectors.toSet());
    }

    private static boolean isSwitchHead(ControlFlowNode node) {
        return !node.getTokens().isEmpty() && node.getTokens().getFirst().getType() == ETokenType.SWITCH;
    }

    private List<ControlFlowNode> handleConditionalGraphNode(ControlFlowNode node, ShallowEntity entity, BullseyeReportHandler.Probe probe, LineCoverageInfo lineCoverageInfo) {
        if (probe == null) {
            probe = new BullseyeReportHandler.Probe(entity.getStartLine(), BullseyeReportHandler.EProbeKind.DECISION, BullseyeReportHandler.EProbeEvent.FULL);
        }
        BullseyeCFGStrategy.addLineCoverageWithProbe(entity, probe, lineCoverageInfo);
        ControlFlowNode yesNode = node.getYesBranch();
        ShallowEntity yesEntity = this.getEntityForNode(yesNode);
        ControlFlowNode noNode = null;
        ShallowEntity noEntity = null;
        if (node.getSuccessors().size() > 1) {
            noNode = node.getNoBranch();
            noEntity = this.getEntityForNode(noNode);
        }
        List<ControlFlowNode> proceedFrom = BullseyeCFGStrategy.collectNodes(entity, probe, lineCoverageInfo, noEntity, yesNode, yesEntity, noNode);
        if (node.getSuccessors().size() > 2) {
            proceedFrom.addAll(node.getSuccessors().subList(2, node.getSuccessors().size()));
        }
        return proceedFrom;
    }

    private static List<ControlFlowNode> collectNodes(ShallowEntity entity, BullseyeReportHandler.Probe probe, LineCoverageInfo lineCoverageInfo, ShallowEntity noEntity, ControlFlowNode yesNode, ShallowEntity yesEntity, ControlFlowNode noNode) {
        ArrayList<ControlFlowNode> proceedFrom = new ArrayList<ControlFlowNode>();
        switch (probe.getProbeEvent()) {
            case TRUE: {
                if (noEntity != null) {
                    BullseyeCFGStrategy.addLineCoverageForEntityAndChildren(noEntity, lineCoverageInfo, ELineCoverage.NOT_COVERED);
                }
                BullseyeCFGStrategy.handleElseEntity(entity, lineCoverageInfo, ELineCoverage.NOT_COVERED);
                proceedFrom.add(yesNode);
                break;
            }
            case FALSE: {
                if (yesEntity != null) {
                    BullseyeCFGStrategy.addLineCoverageForEntityAndChildren(yesEntity, lineCoverageInfo, ELineCoverage.NOT_COVERED);
                }
                BullseyeCFGStrategy.handleElseEntity(entity, lineCoverageInfo, ELineCoverage.FULLY_COVERED);
                if (noNode == null) break;
                proceedFrom.add(noNode);
                break;
            }
            case FULL: {
                proceedFrom.add(yesNode);
                BullseyeCFGStrategy.handleElseEntity(entity, lineCoverageInfo, ELineCoverage.FULLY_COVERED);
                if (noNode == null) break;
                proceedFrom.add(noNode);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                LOGGER.error("Unexpected probe event for probe: {}", (Object)probe);
            }
        }
        return proceedFrom;
    }

    private static void handleElseEntity(ShallowEntity entity, LineCoverageInfo lineCoverageInfo, ELineCoverage lineCoverage) {
        ShallowEntity parentEntity = entity.getParent();
        if (parentEntity == null) {
            return;
        }
        ShallowEntity subsequentEntity = ShallowEntityTraversalUtils.getSubsequentEntity((ShallowEntity)entity);
        if (subsequentEntity != null && subsequentEntity.getSubtype().equals("else")) {
            BullseyeCFGStrategy.addLineCoverage(lineCoverageInfo, subsequentEntity, lineCoverage);
        }
    }

    private static List<ControlFlowNode> handleNonConditionalGraphNode(ControlFlowNode node, ShallowEntity entity, BullseyeReportHandler.Probe probe, LineCoverageInfo lineCoverageInfo) {
        if (probe == null) {
            BullseyeCFGStrategy.addLineCoverage(lineCoverageInfo, entity, ELineCoverage.FULLY_COVERED);
        } else {
            BullseyeCFGStrategy.addLineCoverage(lineCoverageInfo, entity, BullseyeCFGStrategy.getLineCoverageForCoverable(probe));
        }
        return node.getSuccessors();
    }

    private @Nullable ShallowEntity getEntityForNode(ControlFlowNode node) {
        if (node.getTokens().isEmpty()) {
            return null;
        }
        IToken token = node.getTokens().getFirst();
        return this.entityByLineAndOffset.get(token);
    }

    private static ELineCoverage getLineCoverageForDecision(BullseyeReportHandler.Probe decisionProbe) {
        return switch (decisionProbe.getProbeEvent()) {
            case BullseyeReportHandler.EProbeEvent.FULL -> ELineCoverage.FULLY_COVERED;
            case BullseyeReportHandler.EProbeEvent.TRUE, BullseyeReportHandler.EProbeEvent.FALSE -> ELineCoverage.PARTIALLY_COVERED;
            default -> ELineCoverage.NOT_COVERED;
        };
    }

    private static void addLineCoverageForEntityAndChildren(@NonNull ShallowEntity entity, LineCoverageInfo lineCoverageInfo, ELineCoverage lineCoverage) {
        BullseyeCFGStrategy.addLineCoverage(lineCoverageInfo, entity, lineCoverage);
        for (ShallowEntity childEntity : entity.getChildren()) {
            BullseyeCFGStrategy.addLineCoverageForEntityAndChildren(childEntity, lineCoverageInfo, lineCoverage);
        }
    }

    private static void addLineCoverageWithProbe(ShallowEntity entity, BullseyeReportHandler.Probe probe, LineCoverageInfo coverageReceiver) {
        if (probe.getProbeKind() == BullseyeReportHandler.EProbeKind.FUNCTION) {
            BullseyeCFGStrategy.addLineCoverage(coverageReceiver, entity, BullseyeCFGStrategy.getLineCoverageForCoverable(probe));
        } else if (probe.getProbeKind() == BullseyeReportHandler.EProbeKind.DECISION) {
            BullseyeCFGStrategy.addLineCoverage(coverageReceiver, entity, BullseyeCFGStrategy.getLineCoverageForDecision(probe));
        } else if (probe.getProbeKind() == BullseyeReportHandler.EProbeKind.SWITCH_LABEL) {
            BullseyeCFGStrategy.addLineCoverage(coverageReceiver, entity, BullseyeCFGStrategy.getLineCoverageForCoverable(probe));
        }
    }
}

