/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.generic;

import com.teamscale.index.external.ExternalProcessStepInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoProcessStepInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.report.generic.NonCodeMetricsEntry;
import com.teamscale.index.report.parser.ReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class GenericNonCodeMetricsParser
extends ReportParserBase {
    private ExternalAnalysisImportInfos result;

    @Override
    protected void resetState() {
        super.resetState();
        this.result = null;
    }

    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            NonCodeMetricsEntry[] nonCodeMetricEntries = (NonCodeMetricsEntry[])JsonUtils.deserializeFromJsonWithNullCheck((String)report, NonCodeMetricsEntry[].class);
            this.parseReport(Arrays.asList(nonCodeMetricEntries));
        }
        catch (ConQATException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    protected void parseReport(List<NonCodeMetricsEntry> nonCodeMetricEntries) throws ReportParserException {
        ArrayList processStepInfos = new ArrayList();
        for (NonCodeMetricsEntry nonCodeMetricsEntry : nonCodeMetricEntries) {
            ExternalProcessStepInfo processStep = GenericNonCodeMetricsParser.convertToProcessStepInfo(nonCodeMetricsEntry);
            processStepInfos.add(new ExternalAnalysisImportInfoProcessStepInfo(nonCodeMetricsEntry.getUniformPath(), processStep));
        }
        this.result = new ExternalAnalysisImportInfos(processStepInfos);
    }

    private static ExternalProcessStepInfo convertToProcessStepInfo(NonCodeMetricsEntry nonCodeMetricsEntry) throws ReportParserException {
        HashMap<String, Number> numericMetrics = new HashMap<String, Number>();
        HashMap<String, Assessment> assessmentMetrics = new HashMap<String, Assessment>();
        for (Map.Entry<String, Object> metric : nonCodeMetricsEntry.getMetrics().entrySet()) {
            String key = metric.getKey();
            Object value = metric.getValue();
            if (value instanceof Number) {
                Number numericValue = (Number)value;
                numericMetrics.put(key, numericValue);
                continue;
            }
            if (value instanceof List) {
                List listEncodedAssessment = (List)value;
                assessmentMetrics.put(key, GenericNonCodeMetricsParser.decodeAssessment(listEncodedAssessment));
                continue;
            }
            if (value instanceof Map) {
                Map mapEncodedAssessment = (Map)value;
                assessmentMetrics.put(key, GenericNonCodeMetricsParser.decodeAssessment(mapEncodedAssessment));
                continue;
            }
            throw new ReportParserException("Unsupported metric value type: " + String.valueOf(value.getClass()));
        }
        String description = nonCodeMetricsEntry.getContent();
        return new ExternalProcessStepInfo(description, numericMetrics, assessmentMetrics);
    }

    private static Assessment decodeAssessment(List<?> listEncodedAssessment) throws ReportParserException {
        Assessment assessment = new Assessment();
        if (listEncodedAssessment.size() != 3) {
            throw new ReportParserException("Expected list of 3 elements for assessment metric");
        }
        assessment.add(ETrafficLightColor.GREEN, GenericNonCodeMetricsParser.asInteger(listEncodedAssessment.get(0)).intValue());
        assessment.add(ETrafficLightColor.YELLOW, GenericNonCodeMetricsParser.asInteger(listEncodedAssessment.get(1)).intValue());
        assessment.add(ETrafficLightColor.RED, GenericNonCodeMetricsParser.asInteger(listEncodedAssessment.get(2)).intValue());
        return assessment;
    }

    private static Assessment decodeAssessment(Map<?, ?> encodedAssessment) throws ReportParserException {
        Assessment assessment = new Assessment();
        for (Map.Entry<?, ?> encodedPart : encodedAssessment.entrySet()) {
            Object key = encodedPart.getKey();
            if (Arrays.stream(ETrafficLightColor.values()).noneMatch(GenericNonCodeMetricsParser.hasToString((String)key))) {
                throw new ReportParserException("Expected a color key: " + String.valueOf(key));
            }
            assessment.add(ETrafficLightColor.valueOf((String)((String)key)), GenericNonCodeMetricsParser.asInteger(encodedPart.getValue()).intValue());
        }
        return assessment;
    }

    private static Integer asInteger(Object value) throws ReportParserException {
        if (!(value instanceof Integer)) {
            throw new ReportParserException("Expected an integer: " + String.valueOf(value));
        }
        return (Integer)value;
    }

    private static Predicate<Object> hasToString(String toString) {
        return object -> object.toString().equals(toString);
    }

    public final void parse(List<NonCodeMetricsEntry> metrics) throws ReportParserException {
        this.resetState();
        this.parseReport(metrics);
    }

    @Override
    protected ExternalAnalysisImportInfos convertToImportInfos() {
        return this.result;
    }
}

