/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.external.result.ExternalAnalysisResultMetrics;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ExternalAnalysisResultMetricsProcessor
extends ExternalAnalysisResultProcessorBase<ExternalAnalysisResultMetrics> {
    private MetricsIndex metricsIndex;
    private final Map<String, PairList<String, Serializable>> newUniformPathsWithMetricsByPartition = new HashMap<String, PairList<String, Serializable>>();

    public void setMetricsIndex(MetricsIndex metricsIndex) {
        this.metricsIndex = metricsIndex;
    }

    @Override
    public boolean isRelevantPath(UniformPath uniformPath) {
        return uniformPath.isCodePath();
    }

    @Override
    public Class<ExternalAnalysisResultMetrics> getResultClass() {
        return ExternalAnalysisResultMetrics.class;
    }

    @Override
    public boolean extract(String partitionIgnored, UniformPath uniformPath, ExternalAnalysisResultMetrics analysisResult, CommitDescriptor resultsCommit, CommitDescriptor resultsForCommit, BasicTokenElementInfo element) {
        PairList<String, Serializable> metricsByPartition = analysisResult.getData();
        for (int i = 0; i < metricsByPartition.size(); ++i) {
            String partition = (String)metricsByPartition.getFirst(i);
            PairList partitionEntries = this.newUniformPathsWithMetricsByPartition.computeIfAbsent(partition, x -> new PairList());
            partitionEntries.add((Object)uniformPath.toString(), (Object)((Serializable)metricsByPartition.getSecond(i)));
        }
        return true;
    }

    @Override
    public void persist(CommitDescriptor commit) throws StorageException {
        for (Map.Entry<String, PairList<String, Serializable>> metricAndPartitionEntry : this.newUniformPathsWithMetricsByPartition.entrySet()) {
            this.metricsIndex.setMetricValues(metricAndPartitionEntry.getValue(), metricAndPartitionEntry.getKey());
        }
    }

    @Override
    public void processDeleted(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
    }

    @Override
    public void reset() {
        this.newUniformPathsWithMetricsByPartition.clear();
    }
}

