/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.IRepositoryLogEntry;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class RepositoryLogEntry
extends CommitAssociatedObjectBase
implements IRepositoryLogEntry {
    private static final long serialVersionUID = 1L;
    protected static final String REVISION_PROPERTY = "revision";
    protected static final String MESSAGE_PROPERTY = "message";
    protected static final String AUTHOR_PROPERTY = "author";
    protected static final String NUM_ADDED_FILES_PROPERTY = "numAddedFiles";
    protected static final String NUM_CHANGED_FILES_PROPERTY = "numChangedFiles";
    protected static final String NUM_DELETED_FILES_PROPERTY = "numDeletedFiles";
    protected static final String REPOSITORY_IDENTIFIER_PROPERTY = "repositoryIdentifier";
    protected static final String COMMIT_TYPES_PROPERTY = "commitTypes";
    protected static final String UPLOAD_TIMESTAMP_PROPERTY = "uploadTimestamp";
    public static final String EXTERNAL_ANALYSIS_REVISION_PREFIX = "EA";
    private static final String SOURCE_LIBRARY_CHANGE_COMMIT_MESSAGE_PREFIX = "[Source Library Change] ";
    @JsonProperty(value="revision")
    private final String revision;
    @JsonProperty(value="message")
    private @Nullable String message;
    @JsonProperty(value="author")
    private String author;
    @JsonProperty(value="mail")
    private @Nullable String mail;
    @JsonProperty(value="numAddedFiles")
    private final int numAddedFiles;
    @JsonProperty(value="numChangedFiles")
    private final int numChangedFiles;
    @JsonProperty(value="numDeletedFiles")
    private final int numDeletedFiles;
    @JsonProperty(value="repositoryIdentifier")
    private final String repositoryIdentifier;
    @JsonProperty(value="commitTypes")
    private final @Nullable EnumSet<ECommitType> commitTypes;
    @JsonProperty(value="uploadTimestamp")
    private @Nullable Long uploadTimestamp;

    public RepositoryLogEntry(String revision, CommitDescriptor commit, String message, String author, int numAddedFiles, int numChangedFiles, int numDeletedFiles, String repositoryIdentifier, EnumSet<ECommitType> commitTypes) {
        this(revision, commit, message, author, null, numAddedFiles, numChangedFiles, numDeletedFiles, repositoryIdentifier, commitTypes, null);
    }

    @JsonCreator
    public RepositoryLogEntry(@JsonProperty(value="revision") String revision, @JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="message") @Nullable String message, @JsonProperty(value="author") String author, @JsonProperty(value="numAddedFiles") int numAddedFiles, @JsonProperty(value="numChangedFiles") int numChangedFiles, @JsonProperty(value="numDeletedFiles") int numDeletedFiles, @JsonProperty(value="repositoryIdentifier") String repositoryIdentifier, @JsonProperty(value="commitTypes") @NonNull Set<ECommitType> commitTypes, @JsonProperty(value="uploadTimestamp") @Nullable Long uploadTimestamp) {
        this(revision, commit, message, author, null, numAddedFiles, numChangedFiles, numDeletedFiles, repositoryIdentifier, commitTypes, uploadTimestamp);
    }

    public RepositoryLogEntry(String revision, CommitDescriptor commit, @Nullable String message, String author, @Nullable String mail, int numAddedFiles, int numChangedFiles, int numDeletedFiles, String repositoryIdentifier, @NonNull Set<ECommitType> commitTypes, @Nullable Long uploadTimestamp) {
        super(commit);
        this.setCommit(commit);
        this.revision = revision;
        this.message = message;
        this.author = author;
        this.mail = mail;
        this.numAddedFiles = numAddedFiles;
        this.numChangedFiles = numChangedFiles;
        this.numDeletedFiles = numDeletedFiles;
        this.repositoryIdentifier = repositoryIdentifier;
        CCSMAssert.isFalse((boolean)commitTypes.isEmpty(), (String)"Commit types must not be empty");
        this.commitTypes = EnumSet.copyOf(commitTypes);
        this.uploadTimestamp = uploadTimestamp;
    }

    public RepositoryLogEntry(String revision, CommitDescriptor commit, String message, String author, String mail, int numAddedFiles, int numChangedFiles, int numDeletedFiles, String repositoryIdentifier, ECommitType commitType) {
        this(revision, commit, message, author, mail, numAddedFiles, numChangedFiles, numDeletedFiles, repositoryIdentifier, EnumSet.of(commitType), null);
    }

    public RepositoryLogEntry(String revision, CommitDescriptor commit, String message, String author, int numAddedFiles, int numChangedFiles, int numDeletedFiles, String repositoryIdentifier, ECommitType commitType) {
        this(revision, commit, message, author, null, numAddedFiles, numChangedFiles, numDeletedFiles, repositoryIdentifier, EnumSet.of(commitType), null);
    }

    public RepositoryLogEntry(String revision, CommitDescriptor commit, String message, String author, int numAddedFiles, int numChangedFiles, int numDeletedFiles, String repositoryIdentifier, ECommitType commitType, @Nullable Long uploadTimestamp) {
        this(revision, commit, message, author, null, numAddedFiles, numChangedFiles, numDeletedFiles, repositoryIdentifier, EnumSet.of(commitType), uploadTimestamp);
    }

    public static String getSourceLibraryChangeCommitMessage(String originalCommitMessage) {
        return SOURCE_LIBRARY_CHANGE_COMMIT_MESSAGE_PREFIX + originalCommitMessage;
    }

    public boolean isSourceLibraryChangeCommit() {
        return this.commitTypes != null && this.commitTypes.contains((Object)ECommitType.SOURCE_LIBRARY_CHANGE);
    }

    public static RepositoryLogEntry createDummyCodeCommitEntry(CommitDescriptor commit) {
        return new RepositoryLogEntry("", commit, "", "", null, 0, 0, 0, "", EnumSet.of(ECommitType.CODE_COMMIT), null);
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public @Nullable String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getEmail() {
        return this.mail;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public int getNumAddedFiles() {
        return this.numAddedFiles;
    }

    @Override
    public int getNumChangedFiles() {
        return this.numChangedFiles;
    }

    @Override
    public int getNumDeletedFiles() {
        return this.numDeletedFiles;
    }

    public String getRepositoryIdentifier() {
        return this.repositoryIdentifier;
    }

    @Override
    public Set<ECommitType> getCommitTypes() {
        if (this.commitTypes == null) {
            return Collections.emptySet();
        }
        return this.commitTypes;
    }

    @Override
    public @Nullable Long getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    public String toString() {
        return this.revision + " " + String.valueOf(this.getCommit()) + " " + this.author + " " + this.mail + " " + this.message + " " + this.numAddedFiles + " add " + this.numChangedFiles + " change " + this.numDeletedFiles + " delete";
    }

    public int hashCode() {
        return Objects.hash(this.author, this.getCommit(), this.message, this.revision, this.numAddedFiles, this.numChangedFiles, this.numDeletedFiles, this.repositoryIdentifier, this.mail);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RepositoryLogEntry)) {
            return false;
        }
        RepositoryLogEntry other = (RepositoryLogEntry)obj;
        return Objects.equals(this.author, other.author) && Objects.equals(this.getCommit(), other.getCommit()) && Objects.equals(this.message, other.message) && Objects.equals(this.revision, other.revision) && Objects.equals(this.numAddedFiles, other.numAddedFiles) && Objects.equals(this.numChangedFiles, other.numChangedFiles) && Objects.equals(this.numDeletedFiles, other.numDeletedFiles) && Objects.equals(this.repositoryIdentifier, other.repositoryIdentifier) && Objects.equals(this.mail, other.mail);
    }
}

