/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.index.repository.base.RepositoryToTriggerMappingIndex;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class RepositoryUpdateUtils {
    public static <X extends Exception> void extractAndScheduleAffectedTriggers(String repository, IndexLayer indexLayer, ConsumerWithException<Set<InternalProjectId>, X> permissionChecker) throws StorageException, X {
        SetMap<InternalProjectId, String> triggerNamesByProjectId = RepositoryUpdateUtils.determineExternalTriggers(repository, indexLayer);
        if (permissionChecker != null) {
            permissionChecker.accept((Object)triggerNamesByProjectId.getKeys());
        }
        for (InternalProjectId project : triggerNamesByProjectId.getKeys()) {
            for (String triggerName : (Set)triggerNamesByProjectId.getCollection((Object)project)) {
                ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(indexLayer, project, triggerName);
            }
        }
    }

    public static void extractAndScheduleAffectedTriggers(String repository, IndexLayer indexLayer) throws StorageException {
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers(repository, indexLayer, null);
    }

    private static SetMap<InternalProjectId, String> determineExternalTriggers(String repository, IndexLayer indexLayer) throws StorageException {
        SetMap triggerNamesByProjectId = new SetMap();
        ProjectIndex projectIndex = indexLayer.openProjectIndex();
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            if (projectInfo.isDeletingOrReanalyzing()) continue;
            for (String triggerName : RepositoryUpdateUtils.getTriggerNamesForProject(projectInfo, repository, indexLayer)) {
                triggerNamesByProjectId.add((Object)projectInfo.getInternalId(), (Object)triggerName);
            }
        }
        return triggerNamesByProjectId;
    }

    public static List<String> getTriggerNamesForProject(ProjectInfo project, String repository, IndexLayer indexLayer) throws StorageException {
        RepositoryToTriggerMappingIndex mappingIndex = (RepositoryToTriggerMappingIndex)indexLayer.openNonHistorizedProjectIndex(RepositoryToTriggerMappingIndex.class, project);
        return mappingIndex.getTriggerNamesForURL(repository);
    }

    private RepositoryUpdateUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

