/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.IConnectorDescriptorConsistencyValidator;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.base.RepositoryConnectorDescriptorBase;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.CollectionUtils;

public enum DeletePartitionsWithoutUploadsConnectorConsistencyChecker implements IConnectorDescriptorConsistencyValidator
{
    INSTANCE;


    public static DeletePartitionsWithoutUploadsConnectorConsistencyChecker getInstance() {
        return INSTANCE;
    }

    public void validate(List<ConnectorDescriptorBase> connectors) throws ConnectorValidationException {
        List<ArtifactStoreRepositoryConnectorDescriptorBase<?>> relevantConnectors = DeletePartitionsWithoutUploadsConnectorConsistencyChecker.filterArtifactStoreConnectors(connectors);
        if (relevantConnectors.size() < 2) {
            return;
        }
        List<ArtifactStoreRepositoryConnectorDescriptorBase<?>> deletePartitionsEnabledConnectors = relevantConnectors.stream().filter(connector -> connector.deletePartitionsWithoutNewUploads).toList();
        List<ArtifactStoreRepositoryConnectorDescriptorBase<?>> deletePartitionsDisabledConnectors = relevantConnectors.stream().filter(connector -> !connector.deletePartitionsWithoutNewUploads).toList();
        if (deletePartitionsEnabledConnectors.isEmpty() || deletePartitionsDisabledConnectors.isEmpty()) {
            return;
        }
        throw new ConnectorValidationException("Inconsistent connector configuration detected. The following connectors have the option '%s' enabled: %s. However, for the following connectors it is disabled: %s. To avoid unexpected behavior, please ensure that this option is set consistently over all connectors.".formatted("Delete Partitions Without New Uploads", DeletePartitionsWithoutUploadsConnectorConsistencyChecker.extractIdentifiers(deletePartitionsEnabledConnectors), DeletePartitionsWithoutUploadsConnectorConsistencyChecker.extractIdentifiers(deletePartitionsDisabledConnectors)));
    }

    private static @NonNull List<ArtifactStoreRepositoryConnectorDescriptorBase<?>> filterArtifactStoreConnectors(List<ConnectorDescriptorBase> connectors) {
        ArrayList relevantConnectors = new ArrayList();
        for (ConnectorDescriptorBase connector : connectors) {
            if (!(connector instanceof ArtifactStoreRepositoryConnectorDescriptorBase)) continue;
            relevantConnectors.add((ArtifactStoreRepositoryConnectorDescriptorBase)connector);
        }
        return relevantConnectors;
    }

    private static String extractIdentifiers(List<ArtifactStoreRepositoryConnectorDescriptorBase<?>> connectors) {
        return String.join((CharSequence)", ", CollectionUtils.map(connectors, RepositoryConnectorDescriptorBase::getConnectorIdentifier));
    }
}

