/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.external_storage;

import com.google.common.base.Preconditions;
import com.teamscale.index.repository.artifact_store.external_storage.S3ExternalStorageConfigurator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.string.StringUtils;

public final class ExternalStorageConstants {
    public static final String BRANCH_SEPARATOR_DIRECTORY = "__branches__";
    public static final String TIMESTAMP_SEPARATOR_DIRECTORY = "__timestamps__";
    public static final String REPORT_SEPARATOR_DIRECTORY = "__reports__";
    public static final String PARTITION_SEPARATOR_DIRECTORY = "__partitions__";
    public static final String REVISION_SEPARATOR_DIRECTORY = "__revisions__";
    public static final String BRANCH_EXTRACTION_PATTERN = ExternalStorageConstants.createExtractionPattern("__branches__", "__timestamps__");
    public static final String TIMESTAMP_EXTRACTION_PATTERN = ExternalStorageConstants.createExtractionPattern("__timestamps__", "__partitions__");
    public static final String REVISION_EXTRACTION_PATTERN = ExternalStorageConstants.createExtractionPattern("__revisions__", "__partitions__");
    public static final String PARTITION_EXTRACTION_PATTERN = ExternalStorageConstants.createExtractionPattern("__partitions__", "__reports__");
    public static final String PREFIX_EXTRACTION_PATTERN = "(.*)";
    public static final String REPOSITORY_IDENTIFIER = "external-analysis-data";
    public static final String OVERWRITE_EXTERNAL_STORAGE_NAME = "##external-storage-overwrite##";

    public static void registerProjectConfigurationHooks() {
        S3ExternalStorageConfigurator.registerProjectConfigurationHooks();
    }

    private static @NonNull String createExtractionPattern(@NonNull String initializingSeparator, @NonNull String terminatingSeparator) {
        ExternalStorageConstants.checkNonEmpty(initializingSeparator, "initializingSeparator");
        ExternalStorageConstants.checkNonEmpty(terminatingSeparator, "terminatingSeparator");
        return "/" + initializingSeparator + "/(.*)/" + terminatingSeparator + "/";
    }

    private static void checkNonEmpty(String string, String referenceName) throws IllegalArgumentException {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)string) ? 1 : 0) != 0, (Object)"%s must not be empty".formatted(referenceName));
    }

    private ExternalStorageConstants() {
        throw new UnsupportedOperationException("Avoid initialization of this class.");
    }
}

