/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.git.GitCredentials;
import com.teamscale.index.repository.git.GitIndices;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.github.GitHubClientHelper;
import com.teamscale.index.repository.git.github.GitHubRepositoryConnectorDescriptor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;

public class GitHubRepositoryConnector
extends GitRepositoryConnector {
    @StepParameter(value="repository-path")
    private String repositoryPath;
    @StepParameterObject
    private final GitHubClientHelper<RepositoryException> clientHelper;

    public GitHubRepositoryConnector(Logger interactionLogger) {
        this.clientHelper = new GitHubClientHelper<RepositoryException>(RepositoryException::new, interactionLogger);
    }

    public GitHubRepositoryConnector(GitHubRepositoryConnectorDescriptor connectorDescriptor, GitHubInstallationIndex installationIndex, ServerOptionIndex serverOptionIndex, AccessTokenIndex accessTokenIndex, GitIndices gitIndices, IBranchingLayer branchPointerIndexBranchingLayer, Logger interactionLogger) throws ConnectorValidationException {
        super(connectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
        this.repositoryPath = connectorDescriptor.getRepositoryUri().toString();
        this.clientHelper = new GitHubClientHelper<RepositoryException>(connectorDescriptor.getRepositoryName(), GitHubRepositoryConnector.getGitHubServerUrl(this.repositoryPath, connectorDescriptor), installationIndex, serverOptionIndex, accessTokenIndex, RepositoryException::new, interactionLogger);
    }

    @Override
    public GitRepositoryConnection createConnection(IProfilingMonitor profilingMonitor, ICancelable cancelable, IParallelTaskExecutor parallelTaskExecutor) throws RepositoryException {
        try {
            String installationToken = this.clientHelper.getInstallationToken();
            URI repositoryUri = new URI(this.repositoryPath);
            return new GitRepositoryConnection(this.getBaseParameters(), this.gitParameters, new GitCredentials("x-access-token", installationToken, repositoryUri, this.getPrivateKeyOption()), cancelable, true);
        }
        catch (ServiceCallException | URISyntaxException | StorageException e) {
            throw new RepositoryException(e);
        }
    }

    private static String getGitHubServerUrl(String repositoryPath, GitHubRepositoryConnectorDescriptor connectorDescriptor) {
        Object githubServerUrl = "https://github.com/";
        try {
            URL url = new URL(repositoryPath);
            githubServerUrl = url.getProtocol() + "://" + url.getHost();
        }
        catch (MalformedURLException ex) {
            LogManager.getLogger().info("Failed to get GitHub Server URL for " + connectorDescriptor.getRepositoryName() + ". Using default GitHub https://github.com/ instead.");
        }
        return githubServerUrl;
    }
}

