/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.history.match.name;

import com.teamscale.index.repository.history.match.name.PathEntry;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;

@Index(name="paths-by-name", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class PathByNameIndex
implements IProjectIndex {
    private final ValueIndex<PathEntry> delegate;

    public PathByNameIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public static String extractNameFromPath(String uniformPath) {
        return UniformPathUtils.getElementName((String)uniformPath);
    }

    public static List<String> extractNamesFromPaths(List<String> uniformPaths) {
        ArrayList<String> names = new ArrayList<String>();
        for (String uniformPath : uniformPaths) {
            names.add(PathByNameIndex.extractNameFromPath(uniformPath));
        }
        return names;
    }

    public List<PathEntry> getPathsByNames(List<String> names) throws StorageException {
        return this.delegate.getValues(names);
    }

    public void setPathByNameEntries(PairList<String, PathEntry> pathByNameEntries) throws StorageException {
        this.delegate.setValues(pathByNameEntries);
    }

    @VisibleForTesting
    PairList<String, PathEntry> getAllPathByNameEntries() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public PathEntry getPathByName(String name) throws StorageException {
        return (PathEntry)this.delegate.getValue(name);
    }
}

