/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.git.GitCommitMessagesRetriever;
import com.teamscale.index.repository.sap.abapsystem.AbapRepositoryConnectorDescriptor;
import java.net.URI;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class AbapCommitMessagesRetriever
extends GitCommitMessagesRetriever {
    public AbapCommitMessagesRetriever(GlobalStorageSystem storageSystem, Logger interactionLogger) throws StorageException {
        super(storageSystem, interactionLogger);
    }

    @Override
    protected URI getRepositoryUri(ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws ProjectConfigurationException, RepositoryException {
        String sapConnectionIdentifier = connectorConfiguration.getOptionValue("SAP connection");
        try {
            return AbapRepositoryConnectorDescriptor.getGitDirPath(sapConnectionIdentifier, this.serverOptionIndex);
        }
        catch (StorageException e) {
            throw new RepositoryException("Could not determine git repository path", (Throwable)e);
        }
    }
}

