/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.teamscale.index.repository.sap.abapsystem.SapVersion;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Index(name="sap-versions", options={EStorageOption.BACKUP})
public class SapVersionIndex
implements IGlobalIndex {
    private static final String ABAP_VERSION_KEY_PREFIX = "A";
    private static final String CONNECTOR_VERSION_KEY_PREFIX = "C";
    private final ValueIndex<String> delegate;

    public SapVersionIndex(IStore store) {
        this.delegate = ValueIndex.forString((IStore)store);
    }

    public void setVersion(String connectionId, SapVersion version) throws StorageException {
        PairList values = new PairList();
        values.add((Object)(ABAP_VERSION_KEY_PREFIX + connectionId), (Object)version.getAbapVersion());
        values.add((Object)(CONNECTOR_VERSION_KEY_PREFIX + connectionId), (Object)version.getConnectorVersion());
        this.delegate.setValues(values);
    }

    public void removeDeletedSapConnections(Set<String> connectionIdsToRetain) throws StorageException {
        Set storedIds = this.delegate.getAllKeys().stream().map(key -> key.substring(1)).collect(Collectors.toSet());
        storedIds.removeAll(connectionIdsToRetain);
        ArrayList<CallSite> keysToRemove = new ArrayList<CallSite>();
        for (String systemId : storedIds) {
            keysToRemove.add((CallSite)((Object)(ABAP_VERSION_KEY_PREFIX + systemId)));
            keysToRemove.add((CallSite)((Object)(CONNECTOR_VERSION_KEY_PREFIX + systemId)));
        }
        this.delegate.removeValues(keysToRemove);
    }

    public Map<String, SapVersion> getVersionsByConnectionId() throws StorageException {
        Map<String, String> abapVersionByConnectionId = this.delegate.getEntriesStartingWith(ABAP_VERSION_KEY_PREFIX).stream().collect(Collectors.toMap(SapVersionIndex::extractConnectionId, ImmutablePair::getSecond));
        Map<String, String> connectorVersionByConnectionId = this.delegate.getEntriesStartingWith(CONNECTOR_VERSION_KEY_PREFIX).stream().collect(Collectors.toMap(SapVersionIndex::extractConnectionId, ImmutablePair::getSecond));
        HashMap<String, SapVersion> result = new HashMap<String, SapVersion>();
        abapVersionByConnectionId.forEach((id, abapVersion) -> result.put((String)id, new SapVersion((String)abapVersion, (String)connectorVersionByConnectionId.get(id))));
        return result;
    }

    private static String extractConnectionId(Pair<String, String> storageKeyValue) {
        return ((String)storageKeyValue.getFirst()).substring(1);
    }

    public CounterSet<String> getAbapVersionFrequency() throws StorageException {
        return this.getVersionFrequency(ABAP_VERSION_KEY_PREFIX);
    }

    public CounterSet<String> getConnectorVersionFrequency() throws StorageException {
        return this.getVersionFrequency(CONNECTOR_VERSION_KEY_PREFIX);
    }

    private CounterSet<String> getVersionFrequency(String prefix) throws StorageException {
        CounterSet versionFrequency = new CounterSet();
        for (Pair version : this.delegate.getEntriesStartingWith(prefix)) {
            versionFrequency.inc((Object)((String)version.getSecond()));
        }
        return versionFrequency;
    }
}

