/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.retrievers.IBranchRetriever;
import com.teamscale.index.repository.svn.SVNUtils;
import java.util.Set;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class SVNBranchRetriever
implements IBranchRetriever {
    @Override
    public Set<String> fetchBranches(boolean projectExists, String username, ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException {
        String uri = UniformPathUtils.concatenate((String[])new String[]{credentials.uri, connectorConfiguration.getOptionValue("Path suffix")});
        try {
            SVNURL repositoryURL = SVNURL.parseURIEncoded((String)UniformPathUtils.concatenate((String[])new String[]{uri, connectorConfiguration.getOptionValue("Branches directory")}));
            Set<String> branches = SVNUtils.listFilesInDirectory(credentials.username, credentials.password, repositoryURL);
            branches.add("trunk");
            return branches;
        }
        catch (SVNException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }
}

