/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs;

import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import com.teamscale.core.tfs.TfsConnection;
import com.teamscale.core.tfs.TfsException;
import com.teamscale.index.repository.base.CredentialsBasedIntegerRevisionRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.tfs.TfsChangeRetriever;
import com.teamscale.index.repository.tfs.TfsContentUpdater;
import com.teamscale.index.repository.tfs.TfsRepositoryInfoIndex;
import com.teamscale.index.repository.tfs.TfsRepositoryUtils;
import com.teamscale.index.repository.tfs.client.TfsHttpConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;

@ConnectorDescriptor
public class TfsRepositoryConnectorDescriptor
extends CredentialsBasedIntegerRevisionRepositoryConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DEFAULT_BRANCH_NAME_FOR_NON_BRANCHED_MODE = "main";
    @ConfigExposed(name="Branch path suffix", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The subfolder to analyze within each branch. If empty all folders beneath the branch folder are analyzed.")
    protected String branchPathSuffix;
    @ConfigExposed(name="Branch lookup paths", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Sub paths (relative to the directory denoted by Path suffix) in which to look for branches. Values can be separated by commas or entered on separate lines. \nLines starting with '##' are ignored.", multilineText=true)
    public final List<String> branchLookupPaths = new ArrayList<String>();
    @ConfigExposed(name="Non-branched mode", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Whether the repository operates in non-branched mode or not.")
    public boolean nonBranchedMode;
    public static final String BRANCH_LOOKUP_PATHS_OPTION = "Branch lookup paths";
    public static final String BRANCH_PATH_SUFFIX_OPTION = "Branch path suffix";
    public static final String NON_BRANCHED_MODE_OPTION = "Non-branched mode";

    public TfsRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.TFS, DEFAULT_BRANCH_NAME_FOR_NON_BRANCHED_MODE);
        this.autoExpose();
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return TfsChangeRetriever.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return TfsContentUpdater.class;
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(TfsRepositoryInfoIndex.class, this.repositoryIdentifier + "-tfs-repository-infos");
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        if (!StringUtils.isEmpty((String)this.branchPathSuffix)) {
            triggerBuilder.setTriggerParameter("branch-path-suffix", this.branchPathSuffix);
        }
        triggerBuilder.setTriggerParameter("branch-lookup-path", ITriggerParameter.of(this.branchLookupPaths));
        triggerBuilder.renameIndex("tfs-repository-infos", this.repositoryIdentifier + "-tfs-repository-infos");
        triggerBuilder.setTriggerParameter("non-branched-mode", this.nonBranchedMode);
        super.setCommonParameters(triggerBuilder, triggerCreator);
    }

    @Override
    public URI getRepositoryUri() throws ConnectorValidationException {
        return this.parseUri(this.resolveExternalCredentials().uri);
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        if (this.nonBranchedMode && this.branchingEnabled) {
            throw new ConnectorValidationException("Branch analysis cannot be enabled in non-branched mode! Please disable one of these options.");
        }
    }

    @Override
    protected void validateHttpConnection(URI uri) throws ConnectorValidationException {
        try {
            String pathSuffix = this.getPathSuffix();
            if (StringUtils.isEmpty((String)pathSuffix) || !pathSuffix.startsWith("$/")) {
                throw new ConnectorValidationException("Please enter the project path into 'Path suffix'. The format is: $/<PROJECT_NAME>/ followed by a path in the project if you want to limit the analysis to a specific path.");
            }
            try (TfsConnection connection = this.createConnectionForValidation(uri);){
                VersionControlClient versionControlClient = connection.getVersionControlClient();
                TfsConnection.validateAccess((VersionControlClient)versionControlClient);
                TfsConnection.validatePathSuffix((VersionControlClient)versionControlClient, (String)pathSuffix);
                if (this.branchingEnabled) {
                    this.validateDefaultBranch(versionControlClient, pathSuffix);
                    this.validateBranchPathSuffix(versionControlClient, pathSuffix);
                }
            }
        }
        catch (TfsException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    private void validateDefaultBranch(VersionControlClient versionControlClient, String pathSuffix) throws ConnectorValidationException {
        try {
            TfsConnection.validatePathSuffix((VersionControlClient)versionControlClient, (String)(StringUtils.ensureEndsWith((String)pathSuffix, (String)"/") + this.defaultBranchName));
        }
        catch (ConnectorValidationException e) {
            throw new ConnectorValidationException("Invalid default branch: " + this.defaultBranchName + " (" + e.getMessage() + ")", (Throwable)e);
        }
    }

    private void validateBranchPathSuffix(VersionControlClient versionControlClient, String pathSuffix) throws ConnectorValidationException {
        if (!StringUtils.isEmpty((String)this.branchPathSuffix)) {
            try {
                TfsConnection.validatePathSuffix((VersionControlClient)versionControlClient, (String)(StringUtils.ensureEndsWith((String)pathSuffix, (String)"/") + StringUtils.ensureEndsWith((String)this.defaultBranchName, (String)"/") + this.branchPathSuffix));
            }
            catch (ConnectorValidationException e) {
                throw new ConnectorValidationException("Invalid branch path suffix: " + this.branchPathSuffix + " (" + e.getMessage() + ")", (Throwable)e);
            }
        }
    }

    @TestOnly
    void setBranchPathSuffixForTesting(String branchPathSuffix) {
        this.branchPathSuffix = branchPathSuffix;
    }

    private TfsConnection createConnectionForValidation(URI uri) throws ConnectorValidationException, TfsException {
        ExternalCredentials credentials = this.resolveExternalCredentials();
        return new TfsConnection(new ExternalCredentials("credentials", uri.toString(), credentials.username, credentials.password));
    }

    @Override
    protected boolean hasPreselectedUIBranchBeforeBranchTransformationUnlikeDefaultBranch(String preselectedUIBranchBeforeTransform) throws ConnectorValidationException {
        if (!this.branchingEnabled) {
            return false;
        }
        ExternalCredentials credentials = this.resolveExternalCredentials();
        TfsHttpConnection tfsHttpConnection = new TfsHttpConnection(credentials, HttpRequestRetryPolicy.SYSTEM_DEFAULT, LOGGER);
        String pathSuffix = StringUtils.ensureEndsWith((String)this.getPathSuffix(), (String)"/");
        try {
            return TfsRepositoryUtils.existsBranchInPaths(tfsHttpConnection.createAzureDevOpsTfvcRestClient(), pathSuffix, this.branchLookupPaths, new IncludeExcludeRegexSupport(), preselectedUIBranchBeforeTransform);
        }
        catch (RepositoryException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }
}

