/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.connectors;

import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentials;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.index.issue_reference.CodeToSpecItemReferenceMappingSynchronizer;
import com.teamscale.index.issues.IssueTrackerConnectorDescriptorBase;
import com.teamscale.index.issues.updater.BasicTokenElementIndexUpdater;
import com.teamscale.index.issues.updater.BinaryElementIndexUpdater;
import com.teamscale.index.issues.updater.IssueIndexUpdateTrigger;
import com.teamscale.index.issues.updater.IssueMetricsUpdater;
import com.teamscale.index.issues.updater.IssueRepositoryUpdater;
import com.teamscale.index.issues.updater.IssueTrackerContentUpdaterBase;
import com.teamscale.index.issues.updater.TempWorkItemIndexCleaner;
import com.teamscale.index.issues.updater.TypeSpecificIssueTrackerContentUpdaterBase;
import com.teamscale.index.requirements_tracing.index.SpecItemChangesIndex;
import com.teamscale.index.requirements_tracing.index.TempWorkItemIndex;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.wia.LinkRule;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public abstract class RequirementsManagementToolConnectorDescriptorBase
extends IssueTrackerConnectorDescriptorBase {
    public static final String SPEC_ITEM_ID_PATTERN = "Specification item ID pattern";
    public static final String CONNECTOR_IDENTIFIER_PARAMETER_NAME = "Requirements Connector identifier";
    private static final String DEFAULT_CONNECTOR_IDENTIFIER = "requirements1";
    protected static final String SPEC_ITEM_TYPES_TO_ANALYSE_PARAMETER_NAME = "Spec Item types to analyse";
    private static final String ENABLE_SPEC_ITEM_ANALYSIS = "Enable Spec Item analysis";
    public static final String VERIFIES_RELATIONSHIP_DEFINITIONS = "Verifies Relationships";
    private static final String META_KEY_DUMMY_TSA_MODE = "dummy-tsa-mode";
    @ConfigExposed(name="Requirements Connector identifier", description="A unique identifier used to reference the requirements connector.", required=true)
    protected String connectorIdentifier = "requirements1";
    @ConfigExposed(name="Specification item ID pattern", description="The regular expression pattern used to recognize requirement IDs.", changeRequiresReAnalysis=true, visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    protected String specItemIdPattern = null;
    @ConfigExposed(name="Enable Spec Item analysis", description="Whether Teamscale should analyze the imported Spec Items. The checks to execute have to be configured separately in the selected analysis profile. ", dependentOptions={"Spec Item types to analyse"})
    protected boolean enableAnalysis = false;
    @ConfigExposed(name="Spec Item types to analyse", description="Comma separated list of Spec Item types (or type abbreviations) to analyze. If empty, all imported Spec Items will be analyzed.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    protected Set<String> itemTypesToAnalyze = new HashSet<String>();
    @ConfigExposed(name="Verifies Relationships", description="List of 'verifies' relations between different Spec Item types. This is helpful if some spec items represent tests. Example: (\\*) --[tests]-> (\\*)", multilineText=true)
    public List<String> verifiesRelationships = List.of();

    protected RequirementsManagementToolConnectorDescriptorBase(ERequirementsManagementTool requirementsManagementTool) {
        super((IConnectorEnum<?>)requirementsManagementTool, EConnectorType.REQUIREMENTS_MANAGEMENT_TOOL);
    }

    protected RequirementsManagementToolConnectorDescriptorBase(ERequirementsManagementTool requirementsManagementTool, AccountCredentials credentials) {
        super((IConnectorEnum<?>)requirementsManagementTool, EConnectorType.REQUIREMENTS_MANAGEMENT_TOOL, credentials);
    }

    public static boolean isSpecItemAnalysisEnabled(IProjectId projectId, IndexLayer indexLayer) throws StorageException {
        MetaIndex metaIndex = indexLayer.openMetaIndex(projectId);
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)projectId, (IndexLayer)indexLayer);
        return projectConfiguration.getConnectors().stream().anyMatch(connector -> "true".equalsIgnoreCase(connector.getOptionValue(ENABLE_SPEC_ITEM_ANALYSIS))) || Boolean.parseBoolean(metaIndex.getStringValue(META_KEY_DUMMY_TSA_MODE).orElse("false"));
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        if (this.enableAnalysis) {
            indexCreator.createProjectIndex(CommitTreeIndex.class, CommitTreeIndex.getIndexNameForRepository((String)this.getConnectorIdentifier()));
        }
    }

    @Override
    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.configureTriggers(triggerCreator);
        triggerCreator.createTrigger(this.createIssueIndexUpdater(), this.getConnectorIdentifier());
        RequirementsManagementToolConnectorDescriptorBase.createTempWorkItemIndexCleaner(triggerCreator);
        RequirementsManagementToolConnectorDescriptorBase.appendIssueMetricsSynchronizer(triggerCreator, this.getConnectorIdentifier());
        if (this.enableAnalysis) {
            this.configureSpecItemAnalysis(triggerCreator);
        }
        if (this.specItemIdPattern != null && !this.specItemIdPattern.equals("")) {
            RequirementsManagementToolConnectorDescriptorBase.appendRequirementReferencesSynchronizer(triggerCreator, this.specItemIdPattern, this.getConnectorIdentifier());
        }
    }

    private void configureSpecItemAnalysis(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        triggerCreator.createTrigger(this.createIssueRepositoryUpdater(), this.getConnectorIdentifier());
        triggerCreator.createTrigger(this.createBasicTokenElementIndexUpdater(), this.getConnectorIdentifier());
        triggerCreator.createTrigger(this.createBinaryElementIndexUpdater(), this.getConnectorIdentifier());
    }

    private static void createTempWorkItemIndexCleaner(ConnectorDescriptorBase.ITriggerCreator triggerCreator) {
        for (EAnalysisState state : EAnalysisState.values()) {
            triggerCreator.addPostRevisionAnalysisTrigger(state, TempWorkItemIndexCleaner.class);
        }
    }

    private TriggerBuilder createIssueRepositoryUpdater() {
        TriggerBuilder trigger = new TriggerBuilder(IssueRepositoryUpdater.class);
        trigger.renameIndex("single-specitemchanges", SpecItemChangesIndex.getIndexNameForRepository(this.getConnectorIdentifier()));
        trigger.renameIndex("commit-tree", CommitTreeIndex.getIndexNameForRepository((String)this.getConnectorIdentifier()));
        trigger.setTriggerParameter("connector-id", this.getConnectorIdentifier());
        return trigger;
    }

    private TriggerBuilder createBasicTokenElementIndexUpdater() {
        return this.createTypeSpecificIssueTrackerContentUpdaterBase(BasicTokenElementIndexUpdater.class);
    }

    private TriggerBuilder createBinaryElementIndexUpdater() {
        return this.createTypeSpecificIssueTrackerContentUpdaterBase(BinaryElementIndexUpdater.class);
    }

    private TriggerBuilder createTypeSpecificIssueTrackerContentUpdaterBase(Class<? extends TypeSpecificIssueTrackerContentUpdaterBase> triggerClass) {
        TriggerBuilder trigger = this.createIssueTrackerContentUpdaterBase(triggerClass);
        trigger.setTriggerParameter("includedTypes", ITriggerParameter.of(this.itemTypesToAnalyze));
        return trigger;
    }

    private TriggerBuilder createIssueIndexUpdater() {
        TriggerBuilder trigger = this.createIssueTrackerContentUpdaterBase(IssueIndexUpdateTrigger.class);
        trigger.renameIndex("<workItemHistoryIndexNamePlaceholder>", "spec-item-history");
        return trigger;
    }

    private static TriggerBuilder createIssueMetricsUpdater() {
        return new TriggerBuilder(IssueMetricsUpdater.class, ETriggerConcurrency.OUTPUT_ISOLATED);
    }

    private @NonNull TriggerBuilder createIssueTrackerContentUpdaterBase(Class<? extends IssueTrackerContentUpdaterBase> issueIndexUpdaterClass) {
        RequirementsManagementToolConnectorDescriptorBase.ensureSchedulingHintIsPresent(issueIndexUpdaterClass, (EAnalysisStepParameter)EAnalysisStepParameter.MERGE_INPUT_DELTAS);
        TriggerBuilder trigger = new TriggerBuilder(issueIndexUpdaterClass, ETriggerConcurrency.PARALLEL);
        trigger.renameIndex("temp-spec-items", TempWorkItemIndex.getIndexNameForRepository(this.getConnectorIdentifier()));
        trigger.renameIndex("single-specitemchanges", SpecItemChangesIndex.getIndexNameForRepository(this.getConnectorIdentifier()));
        trigger.renameIndex("<workItemIndexNamePlaceholder>", this.getWorkItemIndexName());
        trigger.setTriggerParameter("connector-id", this.getConnectorIdentifier());
        return trigger;
    }

    public final String getConnectorIdentifier() {
        return this.connectorIdentifier;
    }

    @Override
    protected String getWorkItemIndexName() {
        return "spec-items";
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        issueTrackerTriggerBuilder.setSchedulingParameter(ESchedulingParameter.CONCURRENCY, (Object)ETriggerConcurrency.PARALLEL);
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        ConnectorUtils.validateCapturingGroupInRegexPattern((String)this.specItemIdPattern, (String)SPEC_ITEM_ID_PATTERN);
        try {
            List parsed = LinkRule.parse(this.verifiesRelationships);
            if (!parsed.isEmpty() && parsed.stream().anyMatch(rule -> rule.getRelations().isEmpty())) {
                throw new CheckException("Please ensure that all specified relationships have a non-empty link role (predicate).");
            }
            parsed.stream().map(LinkRule::inverse);
        }
        catch (CheckException | IllegalArgumentException e) {
            throw new ConnectorValidationException(String.format("Error in '%s': %s", VERIFIES_RELATIONSHIP_DEFINITIONS, e.getMessage()), e);
        }
    }

    public String getConnectorIdentifierOptionName() {
        return CONNECTOR_IDENTIFIER_PARAMETER_NAME;
    }

    private static void appendRequirementReferencesSynchronizer(ConnectorDescriptorBase.ITriggerCreator triggerCreator, String requirementIdPattern, String issueItemPartition) throws ProjectConfigurationException {
        TriggerBuilder requirementReferenceMappingSynchronizer = new TriggerBuilder(CodeToSpecItemReferenceMappingSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED);
        requirementReferenceMappingSynchronizer.setTriggerParameter("spec-item-id-pattern", requirementIdPattern);
        requirementReferenceMappingSynchronizer.setTriggerParameter("connector-id", issueItemPartition);
        triggerCreator.createTrigger(requirementReferenceMappingSynchronizer, issueItemPartition);
    }

    private static void appendIssueMetricsSynchronizer(ConnectorDescriptorBase.ITriggerCreator triggerCreator, String issueItemPartition) throws ProjectConfigurationException {
        triggerCreator.createTrigger(RequirementsManagementToolConnectorDescriptorBase.createIssueMetricsUpdater(), issueItemPartition);
    }

    public static void appendRequiredSynchronizer(ConnectorDescriptorBase.ITriggerCreator triggerCreator, String requirementIdPattern, String issueItemPartition) throws ProjectConfigurationException {
        RequirementsManagementToolConnectorDescriptorBase.appendRequirementReferencesSynchronizer(triggerCreator, requirementIdPattern, issueItemPartition);
        RequirementsManagementToolConnectorDescriptorBase.appendIssueMetricsSynchronizer(triggerCreator, issueItemPartition);
    }

    @Override
    protected void storeConfigurationDataInternal(ProjectStorageSystem projectStorageSystem) {
    }
}

