/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.azure_devops;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.tfs.IWorkItemRestClient;
import com.teamscale.index.issues.IExternalToolLinkRoleResolver;
import com.teamscale.index.issues.model.ExternalToolLinkRole;
import java.util.List;

public class AzureDevOpsLinkResolver
implements IExternalToolLinkRoleResolver {
    private final IWorkItemRestClient workItemRestClient;

    public AzureDevOpsLinkResolver(IWorkItemRestClient workItemRestClient) {
        this.workItemRestClient = workItemRestClient;
    }

    @Override
    public List<ExternalToolLinkRole> loadLinkRoles() throws ServiceCallException {
        return this.getWorkItemRelationTypes().stream().filter(relation -> relation.getAttributes().isWorkItemLink()).filter(relation -> relation.getAttributes().isEnabled()).map(workItemRelation -> new ExternalToolLinkRole(workItemRelation.getReferenceName(), workItemRelation.getName(), ((IWorkItemRestClient.GetWorkItemRelationTypesResponse.WorkItemRelationType.WorkItemLinkAttributes)workItemRelation.getAttributes()).isBidirectional())).toList();
    }

    private List<IWorkItemRestClient.GetWorkItemRelationTypesResponse.WorkItemRelationType> getWorkItemRelationTypes() throws ServiceCallException {
        return this.workItemRestClient.getWorkItemRelationTypes().getRelations();
    }
}

