/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.cache;

import com.polarion.alm.ws.client.types.tracker.WorkItem;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;

public class PolarionLatestUpdateCacheSupport {
    private final IssueIndexBase<SpecItem> previousSpecItemIndex;
    private final String connectorId;

    public PolarionLatestUpdateCacheSupport(IssueIndexBase<SpecItem> previousSpecItemIndex, String connectorId) {
        this.previousSpecItemIndex = previousSpecItemIndex;
        this.connectorId = connectorId;
    }

    public List<WorkItem> determineWorkItemsUpdatedAfterLatestPolling(List<WorkItem> specItems) throws StorageException {
        Set<TeamscaleIssueId> specItemIds = specItems.stream().map(WorkItem::getId).map(externalId -> new TeamscaleIssueId(this.connectorId, externalId)).collect(Collectors.toSet());
        Map<TeamscaleIssueId, Long> existingSpecItemIdsByLastUpdatedTimestamp = this.previousSpecItemIndex.getIssues(specItemIds).stream().filter(Objects::nonNull).collect(Collectors.toMap(TeamscaleIssue::getId, TeamscaleIssue::getUpdated));
        ArrayList<WorkItem> workItemsUpdatedAfterLatestPolling = new ArrayList<WorkItem>();
        for (WorkItem workItem : specItems) {
            long latestUpdateKnownToTeamscale = existingSpecItemIdsByLastUpdatedTimestamp.getOrDefault(new TeamscaleIssueId(this.connectorId, workItem.getId()), Long.MIN_VALUE);
            if (latestUpdateKnownToTeamscale >= workItem.getUpdated().getTimeInMillis()) continue;
            workItemsUpdatedAfterLatestPolling.add(workItem);
        }
        return workItemsUpdatedAfterLatestPolling;
    }
}

