/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.triggers.rtc;

import com.teamscale.index.issues.rtc.client.model.RtcAuditableLink;
import com.teamscale.index.issues.rtc.client.model.RtcWorkItem;
import com.teamscale.index.requirements_tracing.tools.rtc.model.ERtcWorkItemLinkRole;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.Pair;

public class RtcWorkItemLinkHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern WORK_ITEM_URI_PATTERN = Pattern.compile(".*/com.ibm.team.workitem.WorkItem/(?<workItemId>\\d+)");

    public static Map<String, List<String>> extractLinkRoles(RtcWorkItem workItem, Map<String, String> internalIdLookup) {
        List<RtcAuditableLink> links = workItem.getLinks();
        HashMap<String, List<String>> linkRoleToIds = new HashMap<String, List<String>>();
        for (RtcAuditableLink link : links) {
            Pair<String, String> linkRoleAndId = RtcWorkItemLinkHelper.getLinkRoleAndId(link, workItem, internalIdLookup);
            if (linkRoleAndId == null) continue;
            String linkRoleName = (String)linkRoleAndId.getFirst();
            String workItemId = (String)linkRoleAndId.getSecond();
            linkRoleToIds.putIfAbsent(linkRoleName, new ArrayList());
            if (workItemId == null) continue;
            ((List)linkRoleToIds.get(linkRoleName)).add(workItemId);
        }
        return linkRoleToIds;
    }

    private static Pair<String, String> getLinkRoleAndId(RtcAuditableLink link, RtcWorkItem workItem, Map<String, String> internalIdLookup) {
        ERtcWorkItemLinkRole linkRole = ERtcWorkItemLinkRole.fromType(link.getName());
        if (linkRole == null) {
            LOGGER.error("Unknown link type " + link.getName() + " in work item " + workItem.getIdAsString() + ". Skipping this link type.");
            return null;
        }
        String referenceType = link.getTargetReferenceType();
        if ("URI_REFERENCE".equals(referenceType)) {
            return RtcWorkItemLinkHelper.getLinkForUriReference(workItem, linkRole, link.getTargetUri());
        }
        if ("ITEM_REFERENCE".equals(referenceType)) {
            return RtcWorkItemLinkHelper.getLinkForItemReference(workItem, linkRole, link.getSourceItemId(), link.getTargetItemId(), internalIdLookup);
        }
        LOGGER.error("Unknown or missing reference type for link " + link.getName() + " of work item " + workItem.getIdAsString() + ". Skipping this link.");
        return null;
    }

    private static Pair<String, String> getLinkForUriReference(RtcWorkItem workItem, ERtcWorkItemLinkRole linkRole, String targetUri) {
        if (targetUri == null) {
            LOGGER.error("Link " + linkRole.getReadableLinkRole() + " of work item " + workItem.getIdAsString() + " does not contain an URI to another work item. Skipping this link.");
            return null;
        }
        Matcher matcher = WORK_ITEM_URI_PATTERN.matcher(targetUri);
        if (!matcher.matches()) {
            LOGGER.error("The URI " + targetUri + " could not be matched against the work item URI pattern. Skipping this link.");
            return null;
        }
        String workItemId = matcher.group("workItemId");
        return new Pair((Object)linkRole.getLinkRoleName(), (Object)workItemId);
    }

    private static Pair<String, String> getLinkForItemReference(RtcWorkItem workItem, ERtcWorkItemLinkRole linkRole, String sourceItemId, String targetItemId, Map<String, String> internalToUserVisibleIds) {
        if (sourceItemId == null || targetItemId == null) {
            LOGGER.error("Missing source or target item for link " + linkRole.getReadableLinkRole() + " in work item " + workItem.getIdAsString() + ". Skipping this link.");
            return null;
        }
        String linkRoleName = linkRole.getLinkRoleName();
        String linkedItemId = targetItemId;
        if (targetItemId.equals(workItem.getItemId())) {
            linkRoleName = linkRole.getOppositeLinkRoleName();
            linkedItemId = sourceItemId;
        }
        return new Pair((Object)linkRoleName, (Object)internalToUserVisibleIds.get(linkedItemId));
    }
}

