/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.path_lookup;

import com.google.common.collect.ImmutableList;
import com.teamscale.index.resource.path_lookup.PathLookupUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

class LongestMatchingSuffixPathsCollector {
    private final String fullNormalizedPathReversed;
    private final boolean excludePathsWhereOnlyFileNameMatches;
    private final List<String> matchingPathsWithLongestSuffix = new ArrayList<String>();
    private int currentLongestMatchingPrefixLength = -1;

    protected LongestMatchingSuffixPathsCollector(String fullNormalizedPathReversed, boolean excludePathsWhereOnlyFileNameMatches) {
        this.fullNormalizedPathReversed = fullNormalizedPathReversed;
        this.excludePathsWhereOnlyFileNameMatches = excludePathsWhereOnlyFileNameMatches;
    }

    protected boolean collectPath(String normalizedPathReversed, List<String> originalPaths) {
        int newMatchingPrefixLength = PathLookupUtils.getLongestMatchingPathPrefixLength(this.fullNormalizedPathReversed, normalizedPathReversed);
        if (newMatchingPrefixLength == 0) {
            return this.currentLongestMatchingPrefixLength != -1;
        }
        if (LongestMatchingSuffixPathsCollector.isBetterPrefixMatchThan(newMatchingPrefixLength, this.currentLongestMatchingPrefixLength)) {
            this.currentLongestMatchingPrefixLength = newMatchingPrefixLength;
            this.matchingPathsWithLongestSuffix.clear();
            this.matchingPathsWithLongestSuffix.addAll(originalPaths);
            return false;
        }
        if (this.currentLongestMatchingPrefixLength == newMatchingPrefixLength) {
            this.matchingPathsWithLongestSuffix.addAll(originalPaths);
            return false;
        }
        return true;
    }

    protected Optional<Pair<String, ImmutableList<String>>> getLookupResult(String path) {
        if (this.currentLongestMatchingPrefixLength < 1) {
            return Optional.empty();
        }
        if (!this.isCollectingPathsForFileName() && this.excludePathsWhereOnlyFileNameMatches && this.matchingPathsWithLongestSuffix.size() > 1 && this.onlyFoundFileNameMatches()) {
            this.matchingPathsWithLongestSuffix.removeIf(Predicate.not(PathLookupUtils::isOnlyFileName));
            if (this.matchingPathsWithLongestSuffix.isEmpty()) {
                return Optional.empty();
            }
        }
        String pathWithoutLeadingSlash = StringUtils.stripPrefix((String)path, (String)UniformPathUtils.SEPARATOR);
        String matchedNonNormalizedPath = pathWithoutLeadingSlash.substring(pathWithoutLeadingSlash.length() - this.currentLongestMatchingPrefixLength);
        return Optional.of(new Pair((Object)matchedNonNormalizedPath, (Object)ImmutableList.copyOf(this.matchingPathsWithLongestSuffix)));
    }

    private boolean isCollectingPathsForFileName() {
        return PathLookupUtils.isOnlyFileName(StringUtils.stripSuffix((String)this.fullNormalizedPathReversed, (String)UniformPathUtils.SEPARATOR));
    }

    private boolean onlyFoundFileNameMatches() {
        return PathLookupUtils.isOnlyFileName(this.fullNormalizedPathReversed.substring(0, this.currentLongestMatchingPrefixLength));
    }

    private static boolean isBetterPrefixMatchThan(int newMatchingPrefixLength, int longestMatchingPrefixLength) {
        if (longestMatchingPrefixLength == -1) {
            return true;
        }
        return newMatchingPrefixLength > longestMatchingPrefixLength;
    }
}

