/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricTrendIndex;
import com.teamscale.core.metrics.directory.TrendIndexBase;
import com.teamscale.core.metrics.schema.IMetricSchemaRetriever;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.code_scopes.CodeScopesMetricsUtils;
import com.teamscale.index.resource.retrieval_strategy.IndexMetricRetrievalStrategyBase;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class CodeMetricRetrievalStrategy
extends IndexMetricRetrievalStrategyBase {
    public CodeMetricRetrievalStrategy(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, IMetricSchemaRetriever schemaRetriever, boolean onlyHidden) {
        super(projectStorageSystem, globalStorageSystem, currentUser, schemaRetriever, onlyHidden);
    }

    @Override
    public List<TrendIndexBase.TrendEntry<Object[]>> extractMetricHistory(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        this.verifyNotHiddenForTrend();
        MetricTrendIndex trendIndex = (MetricTrendIndex)this.projectStorageSystem.openProjectIndex(MetricTrendIndex.class, "metric-trend", null);
        return this.extractTrend(trendIndex, uniformPath, start, end);
    }

    @Override
    public MetricDirectoryEntry getMetricDirectoryEntry(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        String path = CodeMetricRetrievalStrategy.stripPath(uniformPath);
        MetricDirectoryEntry entry = super.getMetricDirectoryEntry(uniformPath, historyAccessOption);
        if (entry != null) {
            CodeMetricRetrievalStrategy.removeArtificialPaths(path, entry);
        }
        return entry;
    }

    @Override
    public List<MetricDirectoryEntry> getMetricDirectoryEntries(List<String> uniformPathPrefixes, HistoryAccessOption historyAccessOption) throws StorageException {
        List<MetricDirectoryEntry> metricDirectoryEntries = super.getMetricDirectoryEntries(uniformPathPrefixes, historyAccessOption);
        return metricDirectoryEntries.stream().filter(metricDirectoryEntry -> !CodeMetricRetrievalStrategy.isArtificialEntry(metricDirectoryEntry)).collect(Collectors.toList());
    }

    private static boolean isArtificialEntry(MetricDirectoryEntry metricDirectoryEntry) {
        return metricDirectoryEntry.getUniformPath().startsWith(ArchitectureMetricsUtils.ROOT_PATH_TO_ARCHITECTURES) || metricDirectoryEntry.getUniformPath().startsWith(CodeScopesMetricsUtils.CODE_SCOPES_ROOT_PATH) || metricDirectoryEntry.getUniformPath().startsWith("-architecture-files-");
    }

    private static void removeArtificialPaths(String uniformPath, MetricDirectoryEntry entry) {
        if (uniformPath.isEmpty()) {
            entry.removeChild(ArchitectureMetricsUtils.ROOT_PATH_TO_ARCHITECTURES);
            entry.removeChild(CodeScopesMetricsUtils.CODE_SCOPES_ROOT_PATH);
            entry.removeChild("-architecture-files-");
        }
    }
}

