/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.search;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.index.CommitAssociationIndexBase;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.index.comment_analysis.identifier.EStopWords;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.HiddenTokenElementDetail;
import com.teamscale.index.search.CodeSearchIndex;
import com.teamscale.index.search.ESearchTokenSourceType;
import com.teamscale.index.search.SearchToken;
import com.teamscale.index.utils.ExternalUploadUtils;
import com.teamscale.wia.TeamscaleIssue;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CodeSearchSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_TOKEN_SIZE = 10000;
    public static final Pattern TOKENIZATION_PATTERN = Pattern.compile("(^[\\da-f]{8,40}$)|([a-zA-Z_][-_a-zA-Z\\d]+)");
    public static final String INDEX_ALL_TOKENS_PARAMETER = "index-all-tokens";
    private static final Pattern PREPROCESSOR_MACRO_NAME_PATTERN = Pattern.compile("^\\s*#\\s*define\\s+(\\w+)", 2);
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex projectMetaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CodeSearchIndex codeSearchIndex;
    @StepParameter(value="index-all-tokens")
    private boolean indexAllTokens;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private RepositoryLogIndex repositoryLogIndex;
    @DeltaSource(value=RepositoryLogIndex.class)
    private KeyDelta logDelta;
    @DeltaSource(value=IssueIndex.class)
    private KeyDelta issueDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private IssueIndex issueIndex;
    @DeltaSource(value=SpecItemIndex.class)
    private KeyDelta specItemDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SpecItemIndex specItemIndex;

    public void execute() throws StorageException, ExecutionException {
        if (PreCommitUtils.isPrecommitBranch((String)this.getSchedulingCommit().getBranchName())) {
            return;
        }
        this.processLogDelta();
        if (this.isDefaultBranch(this.getSchedulingCommit())) {
            this.processContentDelta();
        }
        this.processIssueDelta();
        this.processSpecItemDelta();
    }

    private boolean isDefaultBranch(CommitDescriptor commit) throws StorageException {
        return commit.getBranchName().equals(this.projectMetaIndex.getDefaultBranchName());
    }

    private void processLogDelta() throws StorageException {
        List commits = CommitAssociationIndexBase.deltaToCommits((KeyDelta)this.logDelta);
        if (commits.isEmpty()) {
            return;
        }
        List entries = CollectionUtils.filter((Collection)this.repositoryLogIndex.getEntries(commits), log -> log != null && log.containsRepositoryIdentifier(ExternalUploadUtils::isCodeCommit));
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<SearchToken> tokens = new ArrayList<SearchToken>();
        for (RepositoryLogEntryAggregate logEntry : entries) {
            CommitDescriptor commit = logEntry.getCommit();
            if (!logEntry.getCommitTypes().contains((Object)ECommitType.CODE_COMMIT) || StringUtils.isEmpty((String)logEntry.getMessage())) continue;
            String commitJson = commit.toJson();
            CodeSearchSynchronizer.tokenize(ESearchTokenSourceType.COMMIT, commitJson, (byte)5, logEntry.getMessage(), 0, tokens);
            CodeSearchSynchronizer.tokenize(ESearchTokenSourceType.COMMIT, commitJson, (byte)1, logEntry.getAuthor(), 0, tokens);
            tokens.add(new SearchToken(logEntry.getRevision(), ESearchTokenSourceType.COMMIT, commitJson, 0, 10));
            tokens.add(new SearchToken(StringUtils.truncate((String)logEntry.getRevision(), (int)8), ESearchTokenSourceType.COMMIT, commitJson, 0, 10));
        }
        this.codeSearchIndex.storeTokens(tokens);
    }

    private void processIssueDelta() throws StorageException {
        this.codeSearchIndex.storeTokens(CodeSearchSynchronizer.processIssueDelta(this.issueIndex, this.issueDelta, ESearchTokenSourceType.ISSUE));
    }

    private void processSpecItemDelta() throws StorageException {
        this.codeSearchIndex.storeTokens(CodeSearchSynchronizer.processIssueDelta(this.specItemIndex, this.specItemDelta, ESearchTokenSourceType.SPEC_ITEM));
    }

    private static List<SearchToken> processIssueDelta(IssueIndexBase<? extends TeamscaleIssue> issueIndex, KeyDelta issueDelta, ESearchTokenSourceType sourceType) throws StorageException {
        List changedKeys = issueIndex.resolveDelta(issueDelta).getAddedOrChangedKeysAsStrings();
        if (changedKeys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SearchToken> tokens = new ArrayList<SearchToken>();
        List<? extends TeamscaleIssue> changedIssues = issueIndex.getIssuesForInternalIds(changedKeys);
        for (int i = 0; i < changedIssues.size(); ++i) {
            TeamscaleIssue issue = changedIssues.get(i);
            if (issue == null) {
                LOGGER.error("Could not resolve issue for key '{}'", changedKeys.get(i));
                continue;
            }
            tokens.add(new SearchToken(issue.getId().getExternalId(), sourceType, issue.getIdAsString(), 0, 10));
            CodeSearchSynchronizer.tokenize(sourceType, issue.getIdAsString(), (byte)5, issue.getId().getExternalId(), 0, tokens);
            CodeSearchSynchronizer.tokenize(sourceType, issue.getIdAsString(), (byte)5, issue.getSubject(), 0, tokens);
            CodeSearchSynchronizer.tokenize(sourceType, issue.getIdAsString(), (byte)1, issue.getDescription(), 0, tokens);
        }
        return tokens;
    }

    private void processContentDelta() throws StorageException, ExecutionException {
        if (!this.contentDelta.getDeletedKeys().isEmpty()) {
            this.codeSearchIndex.removeSources(ESearchTokenSourceType.CODE, this.contentDelta.getDeletedKeysAsStrings());
            this.codeSearchIndex.removeSources(ESearchTokenSourceType.PATH, this.contentDelta.getDeletedKeysAsStrings());
        }
        List fileWithsWithoutArchitectures = CollectionUtils.filter((Collection)this.contentDelta.getAddedOrChangedKeysAsStrings(), uniformPath -> !UniformPathUtils.isArchitectureFile((String)uniformPath));
        this.executeInParallelBatches(fileWithsWithoutArchitectures, this::processContentDeltaBatch);
    }

    private void processContentDeltaBatch(List<String> changedPaths) throws StorageException {
        ArrayList<SearchToken> tokens = new ArrayList<SearchToken>();
        for (TokenElementInfo elementInfo : this.contentIndex.getTokenElements(changedPaths)) {
            if (elementInfo == null || elementInfo.getFirstDetailOfType(HiddenTokenElementDetail.class).isPresent()) continue;
            String uniformPath = elementInfo.getUniformPath();
            CodeSearchSynchronizer.tokenize(ESearchTokenSourceType.PATH, uniformPath, (byte)10, UniformPathUtils.getElementName((String)uniformPath), 0, tokens);
            if (this.indexAllTokens) {
                CodeSearchSynchronizer.extractSearchTokensFromAllCode(elementInfo, tokens);
                continue;
            }
            if (elementInfo.getLanguage().isCppOrC()) {
                CodeSearchSynchronizer.extractSearchTokensFromPreprocessorMacros(elementInfo, tokens);
            }
            CodeSearchSynchronizer.extractSearchTokensFromCommentsAndLiterals(elementInfo, tokens);
            if (elementInfo.getShallowEntitiesWithoutPreprocessorTokens() == null) continue;
            CodeSearchSynchronizer.extractSearchTokensFromTypeAndMethodNames(elementInfo, tokens);
        }
        this.codeSearchIndex.storeTokens(tokens);
    }

    private static void extractSearchTokensFromAllCode(TokenElementInfo elementInfo, List<SearchToken> tokens) {
        for (IToken token : elementInfo.getTokens()) {
            CodeSearchSynchronizer.tokenize(ESearchTokenSourceType.CODE, elementInfo.getUniformPath(), (byte)5, token.getText(), token.getOffset(), tokens);
        }
    }

    private static void extractSearchTokensFromPreprocessorMacros(TokenElementInfo elementInfo, List<SearchToken> tokens) {
        for (IToken token : elementInfo.getTokens()) {
            Matcher matcher;
            if (token.getType() != ETokenType.PREPROCESSOR_DIRECTIVE || !(matcher = PREPROCESSOR_MACRO_NAME_PATTERN.matcher(token.getText())).find() || CodeSearchSynchronizer.isFilteredText(matcher.group(1))) continue;
            tokens.add(new SearchToken(CodeSearchSynchronizer.limitTokenLength(matcher.group(1)), ESearchTokenSourceType.CODE, elementInfo.getUniformPath(), token.getOffset() + matcher.start(1), 10));
        }
    }

    private static void extractSearchTokensFromCommentsAndLiterals(TokenElementInfo elementInfo, List<SearchToken> tokens) {
        for (IToken token : elementInfo.getTokens()) {
            if (token.getType() != ETokenType.STRING_LITERAL && token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT) continue;
            CodeSearchSynchronizer.tokenize(ESearchTokenSourceType.CODE, elementInfo.getUniformPath(), (byte)5, token.getText(), token.getOffset(), tokens);
        }
    }

    private static void extractSearchTokensFromTypeAndMethodNames(TokenElementInfo elementInfo, List<SearchToken> tokens) {
        for (ShallowEntity entity : ShallowEntityTraversalUtils.listEntitiesOfTypes(elementInfo.getShallowEntitiesWithoutPreprocessorTokens(), EnumSet.of(EShallowEntityType.TYPE, EShallowEntityType.METHOD))) {
            String entityName = CodeSearchSynchronizer.extractLastToken(entity.getName());
            if (entityName == null || entity.isEmpty() || !entity.hasValidStartToken()) continue;
            int offset = entity.getStartOffset();
            for (IToken token : entity.ownStartTokens()) {
                if (!entityName.startsWith(token.getText())) continue;
                offset = token.getOffset();
                break;
            }
            tokens.add(new SearchToken(entityName, ESearchTokenSourceType.CODE, elementInfo.getUniformPath(), offset, 10));
        }
    }

    private static String extractLastToken(String name) {
        if (name == null) {
            return null;
        }
        String previous = null;
        Matcher matcher = TOKENIZATION_PATTERN.matcher(name);
        while (matcher.find()) {
            previous = matcher.group();
        }
        return previous;
    }

    private static void tokenize(ESearchTokenSourceType sourceType, String sourceName, byte significance, String text, int baseOffset, List<SearchToken> tokens) {
        if (text.isEmpty()) {
            return;
        }
        Matcher matcher = TOKENIZATION_PATTERN.matcher(text);
        while (matcher.find()) {
            String tokenText = matcher.group();
            if (CodeSearchSynchronizer.isFilteredText(tokenText)) continue;
            tokens.add(new SearchToken(CodeSearchSynchronizer.limitTokenLength(tokenText), sourceType, sourceName, baseOffset + matcher.start(), significance));
        }
    }

    private static String limitTokenLength(String tokenText) {
        if (tokenText.length() >= 10000) {
            return tokenText.substring(0, 9999);
        }
        return tokenText;
    }

    private static boolean isFilteredText(String tokenText) {
        return tokenText.length() <= 1 || EStopWords.isAnyStopWord(tokenText);
    }
}

