/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type;

import com.google.common.collect.Multimap;
import com.teamscale.index.simulink.signal_type.SimulinkDataTypeUpdater;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLink;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.MatlabVariable;
import org.conqat.lib.simulink.builder.SimulinkAliasType;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkEnumeratedType;
import org.conqat.lib.simulink.builder.SimulinkParameter;
import org.conqat.lib.simulink.builder.SimulinkSignal;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

class SimulinkDataTypeAnalyserInPlace {
    private static final String MINIMUM_SIGNED_DATATYPE = "int32";
    private static final String MINIMUM_UNSIGNED_DATATYPE = "uint32";
    private final SimulinkDataTypeUpdater updater;
    private final Map<String, String> blockTypeToOutputDataType = Map.ofEntries(Map.entry("AsciiToString", "string"), Map.entry("ComposeString", "string"), Map.entry("StringCompare", "boolean"), Map.entry("StringConcatenate", "string"), Map.entry("StringConstant", "string"), Map.entry("StringContains", "boolean"), Map.entry("StringToAscii", "uint8"), Map.entry("StringToEnum", "enum"), Map.entry("Substring", "string"), Map.entry("ToString", "string"), Map.entry("Derivative", "double"), Map.entry("DescriptorStateSpace", "double"), Map.entry("FirstOrderHold", "double"), Map.entry("Integrator", "double"), Map.entry("SecondOrderIntegrator", "double"), Map.entry("StateSpace", "double"), Map.entry("TransportDelay", "double"), Map.entry("VariableTransportDelay", "double"), Map.entry("ZeroPole", "double"), Map.entry("HitCross", "double"), Map.entry("VariablePulseGenerator", "double"), Map.entry("Sin", "double"), Map.entry("Clock", "double"), Map.entry("DigitalClock", "double"), Map.entry("Enumerated Constant", "enum"), Map.entry("RandomNumber", "double"), Map.entry("SignalGenerator", "double"), Map.entry("UniformRandomNumber", "double"));

    SimulinkDataTypeAnalyserInPlace(SimulinkResolvedDataTypes resolvedDataTypes, Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks) {
        this.updater = new SimulinkDataTypeUpdater(resolvedDataTypes, typeLinks);
    }

    public void resolveDataTypes(SimulinkModel model, List<SimulinkDataDictionary> dataDictionaries) {
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)true, (boolean)true)) {
            this.determineDataTypeFromSignalObject(block, dataDictionaries);
            this.determineDataTypeFromBlockParameters(block, dataDictionaries);
            this.determineDataTypeAliasFromDictionary(block, dataDictionaries);
            this.determineDataTypeFromLibraryFunctions(block);
        }
    }

    private void determineDataTypeFromSignalObject(SimulinkBlock block, List<SimulinkDataDictionary> dataDictionaries) {
        for (SimulinkOutPort outPort : block.getOutPorts()) {
            String dataType;
            String signalName;
            Optional signalFromDictionary;
            boolean useSignalFromDictionary = "on".equals(outPort.getParameter("MustResolveToSignalObject"));
            if (!useSignalFromDictionary || (signalFromDictionary = SimulinkUtils.findDataDictionaryEntry(dataDictionaries, (String)(signalName = outPort.getParameter("Name")), SimulinkSignal.class)).isEmpty() || "auto".equals(dataType = ((SimulinkSignal)signalFromDictionary.get()).getDataType())) continue;
            signalFromDictionary.ifPresent(simulinkSignal -> this.updater.updateInformation(block, outPort.getIndex(), dataType));
        }
    }

    private void determineDataTypeFromBlockParameters(SimulinkBlock block, List<SimulinkDataDictionary> dataDictionaries) {
        String dataType = SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)block);
        if (dataType == null) {
            return;
        }
        if (block.isOfType("PreLookup")) {
            this.determineDataTypeOfPrelookup(block);
        } else if ("Inherit: Inherit via internal rule".equals(dataType)) {
            if (block.isOfType("StringFind")) {
                this.updater.updateInformation(block, MINIMUM_SIGNED_DATATYPE);
            } else if (block.isOfType("StringLength") || block.isOfType("StringCount")) {
                this.updater.updateInformation(block, MINIMUM_UNSIGNED_DATATYPE);
            }
        } else if (SimulinkDataTypeUtils.isBuiltInDataType((String)dataType)) {
            this.updater.updateInformation(block, dataType);
        } else if ("Inherit: Logical (see Configuration Parameters: Optimization)".equals(dataType)) {
            this.determineDataTypeLogical(block);
        } else if ("Inherit: Inherit from 'Constant value'".equals(dataType)) {
            this.determineDataTypeFromConstantValue(block, dataDictionaries);
        } else if (dataType.toLowerCase().startsWith("fixdt")) {
            this.determineFixedDataTypeConstructor(block);
        } else if (dataType.toLowerCase().startsWith("sfix(") || dataType.toLowerCase().startsWith("ufix(")) {
            this.determineFixedDataType(block, dataType);
        } else if (SimulinkDataTypeUtils.isEnumDataType((String)dataType)) {
            this.determineEnumDataType(block);
        } else if (block.isOfType("Interpolation_n-D") && !"Inherit: Inherit via back propagation".equals(dataType) && "Dialog".equals(block.getParameter("TableSource"))) {
            this.determineDataTypeFromTableData(block);
        } else if (block.isOfType("LookupNDDirect") && "off".equals(block.getParameter("TableIsInput"))) {
            this.determineDataTypeFromTableData(block);
        }
    }

    private void determineDataTypeAliasFromDictionary(SimulinkBlock block, List<SimulinkDataDictionary> dataDictionaries) {
        String dataType = SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)block);
        if (dataType == null) {
            return;
        }
        if (SimulinkDataTypeUtils.isBuiltInDataType((String)dataType) || dataType.startsWith("Inherit: ") || SimulinkDataTypeUtils.isBusDataType((String)dataType)) {
            return;
        }
        Optional simulinkAliasType = SimulinkUtils.findDataDictionaryEntry(dataDictionaries, (String)dataType, SimulinkAliasType.class);
        if (simulinkAliasType.isPresent()) {
            this.updater.updateInformation(block, ((SimulinkAliasType)simulinkAliasType.get()).getDataType());
        }
    }

    private void determineDataTypeFromLibraryFunctions(SimulinkBlock block) {
        if (this.blockTypeToOutputDataType.containsKey(block.getType())) {
            this.updater.updateInformation(block, this.blockTypeToOutputDataType.get(block.getType()));
        }
    }

    private void determineFixedDataType(SimulinkBlock block, String dataTypeString) {
        String realDataType = switch (dataTypeString) {
            case "sfix(8)" -> "int8";
            case "sfix(16)" -> "int16";
            case "sfix(32)" -> MINIMUM_SIGNED_DATATYPE;
            case "sfix(64)" -> "int64";
            case "ufix(8)" -> "uint8";
            case "ufix(16)" -> "uint16";
            case "ufix(32)" -> MINIMUM_UNSIGNED_DATATYPE;
            case "ufix(64)" -> "uint64";
            default -> "double";
        };
        this.updater.updateInformation(block, realDataType);
    }

    private void determineDataTypeOfPrelookup(SimulinkBlock block) {
        String outputSelection = block.getParameter("OutputSelection");
        String indexDataType = SimulinkDataTypeUtils.normalizeDataType((String)block.getParameter("IndexDataTypeStr"));
        String fractionDataType = SimulinkDataTypeUtils.normalizeDataType((String)block.getParameter("FractionDataTypeStr"));
        if (!SimulinkDataTypeUtils.isBuiltInDataType((String)fractionDataType)) {
            fractionDataType = SimulinkDataTypeUtils.normalizeDataType((String)block.getParameter("BreakpointDataTypeStr"));
        }
        if ("Inherit: Inherit from 'Breakpoint data'".equals(fractionDataType)) {
            fractionDataType = SimulinkDataTypeUtils.determineDataTypeOfValue((String)block.getParameter("BreakpointsData"));
        }
        if ("Index only".equals(outputSelection)) {
            this.updater.updateInformation(block, "1", indexDataType);
        } else if ("Index and fraction".equals(outputSelection)) {
            this.updater.updateInformation(block, "1", indexDataType);
            if (SimulinkDataTypeUtils.isBuiltInDataType((String)fractionDataType)) {
                this.updater.updateInformation(block, "2", fractionDataType);
            }
        } else if ("Index and fraction as bus".equals(outputSelection)) {
            this.updater.updateInformation(block, "Bus");
        }
    }

    private void determineDataTypeLogical(SimulinkBlock block) {
        this.updater.updateInformation(block, "boolean");
    }

    private void determineFixedDataTypeConstructor(SimulinkBlock block) {
        String dataType = SimulinkDataTypeUtils.getRealDataTypeOfFixedDataType((String)SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)block), (boolean)false);
        this.updater.updateInformation(block, dataType);
    }

    private void determineDataTypeFromConstantValue(SimulinkBlock block, List<SimulinkDataDictionary> dataDictionaries) {
        Optional<String> resolvedDataType;
        String constantValue = block.getParameter("Value");
        if (constantValue == null) {
            this.updater.updateInformation(block, "Unknown");
            return;
        }
        String maskedParameterName = block.getParent().getParameter("Mask.MaskParameter.Name");
        if (maskedParameterName != null && maskedParameterName.equals(constantValue)) {
            constantValue = block.getParent().getParameter("Mask.MaskParameter.Value");
        }
        if ((resolvedDataType = SimulinkDataTypeAnalyserInPlace.resolveDataTypeFromDataDictionary(constantValue, dataDictionaries)).isEmpty()) {
            resolvedDataType = SimulinkDataTypeAnalyserInPlace.resolveDataTypeFromModelWorkspace(constantValue, block.getModel());
        }
        if (resolvedDataType.isEmpty()) {
            resolvedDataType = Optional.of(SimulinkDataTypeUtils.determineDataTypeOfValue((String)constantValue));
        }
        this.updater.updateInformation(block, resolvedDataType.get());
    }

    private void determineEnumDataType(SimulinkBlock block) {
        this.updater.updateInformation(block, "enum");
    }

    private void determineDataTypeFromTableData(SimulinkBlock block) {
        String dataType = SimulinkDataTypeUtils.determineDataTypeOfValue((String)block.getParameter("Table"));
        this.updater.updateInformation(block, dataType);
    }

    private static Optional<String> resolveDataTypeFromDataDictionary(String constantValue, List<SimulinkDataDictionary> dataDictionaries) {
        String value;
        Optional<ISimulinkDataDictionaryEntry> entry = Stream.of(SimulinkUtils.findDataDictionaryEntry(dataDictionaries, (String)constantValue, MatlabVariable.class), SimulinkUtils.findDataDictionaryEntry(dataDictionaries, (String)constantValue, SimulinkParameter.class), SimulinkUtils.findDataDictionaryEntry(dataDictionaries, (String)constantValue, SimulinkEnumeratedType.class)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (entry.isEmpty()) {
            return Optional.empty();
        }
        if (entry.get() instanceof MatlabVariable) {
            value = ((MatlabVariable)entry.get()).value;
        } else if (entry.get() instanceof SimulinkParameter) {
            value = ((SimulinkParameter)entry.get()).value;
        } else if (entry.get() instanceof SimulinkEnumeratedType) {
            value = constantValue;
        } else {
            return Optional.empty();
        }
        String dataType = entry.get().getDataType();
        if ("auto".equals(dataType)) {
            dataType = SimulinkDataTypeUtils.determineDataTypeOfValue((String)value);
        }
        return Optional.of(SimulinkDataTypeUtils.normalizeDataType((String)dataType));
    }

    private static Optional<String> resolveDataTypeFromModelWorkspace(String constantValue, SimulinkModel model) {
        Optional parameter = model.modelWorkspace.findParameter(constantValue);
        if (parameter.isEmpty()) {
            return Optional.empty();
        }
        String dataType = ((SimulinkParameter)parameter.get()).getDataType();
        if ("auto".equals(dataType)) {
            dataType = SimulinkDataTypeUtils.determineDataTypeOfValue((String)((SimulinkParameter)parameter.get()).value);
        }
        return Optional.of(dataType);
    }
}

