/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.teamscale.index.simulink.signal_type.SimulinkNavigationUtils;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLink;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.datahandler.GotoFromResolver;
import org.conqat.lib.simulink.model.datahandler.ModelDataHandler;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkTypeLinkExtractor {
    public static final Set<String> BLOCK_TYPES_ACCEPTING_PROPAGATED_SIGNAL_LABEL = Set.of("Goto", "From", "FunctionCallSplit", "SignalSpecification", "SubSystem", "Inport", "Outport");
    private final Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks = ArrayListMultimap.create();
    private final SimulinkBlock rootBlock;
    private final GotoFromResolver gotoFromResolver;

    public SimulinkTypeLinkExtractor(SimulinkBlock rootBlock) {
        this.rootBlock = rootBlock;
        this.gotoFromResolver = ModelDataHandler.createGotoFromResolver((SimulinkBlock)rootBlock);
    }

    public Multimap<SimulinkBlock, SimulinkTypeLink> extractInheritAutoTypeLinks() {
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)this.rootBlock, (boolean)true, (boolean)true)) {
            if (SimulinkDataTypeUtils.hasAutoOrImplicitTypeInheritance((SimulinkBlock)block)) {
                this.extractTypeLinks(block);
            }
            if (!block.isOfType("Outport")) continue;
            this.extractSpecialLinksForOutport(block);
        }
        return this.typeLinks;
    }

    public Multimap<SimulinkBlock, SimulinkTypeLink> extractSignalLabelTypeLinks() {
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)this.rootBlock, (boolean)true, (boolean)true)) {
            if (BLOCK_TYPES_ACCEPTING_PROPAGATED_SIGNAL_LABEL.contains(block.getType())) {
                this.extractTypeLinks(block);
            }
            if (!block.isOfType("Outport")) continue;
            this.extractSpecialLinksForOutport(block);
        }
        return this.typeLinks;
    }

    public Multimap<SimulinkBlock, SimulinkTypeLink> extractDimensionLinks() {
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)this.rootBlock, (boolean)true, (boolean)true)) {
            if (SimulinkUtils.inheritsDimension((SimulinkBlock)block)) {
                this.extractTypeLinks(block);
            }
            if (!block.isOfType("Outport")) continue;
            this.extractSpecialLinksForOutport(block);
        }
        return this.typeLinks;
    }

    private void extractTypeLinks(SimulinkBlock block) {
        this.addLinkFromPredecessors(block);
        this.addLinkFromPredecessorToInport(block);
        this.addLinkToShadowInports(block);
    }

    private void extractSpecialLinksForOutport(SimulinkBlock outportBlock) {
        this.addLinksForOutportBlock(outportBlock);
        this.addStateflowLinks(outportBlock);
    }

    private void addLinkFromPredecessors(SimulinkBlock block) {
        if (block.isOfType("BusCreator") || block.isOfType("SubSystem")) {
            return;
        }
        if (block.isOfType("From")) {
            this.gotoFromResolver.getConnectedGotoBlocks(block).forEach(gotoBlock -> this.typeLinks.put(gotoBlock, (Object)new SimulinkTypeLink((SimulinkBlock)gotoBlock, block)));
        }
        for (SimulinkOutPort predecessorPort : SimulinkNavigationUtils.getPredecessorPorts(block)) {
            SimulinkBlock trigger = predecessorPort.getBlock();
            String sourcePortIndex = predecessorPort.getIndex();
            if (trigger.isOfType("SubSystem")) {
                Optional outport = SimulinkUtils.findOutPortBlock((SimulinkBlock)trigger, (String)sourcePortIndex);
                if (outport.isEmpty()) continue;
                trigger = (SimulinkBlock)outport.get();
            }
            if (trigger.getOutPorts().size() > 1) {
                this.storeTypeLink(new SimulinkTypeLink(trigger, block, sourcePortIndex, ""));
                continue;
            }
            this.storeTypeLink(new SimulinkTypeLink(trigger, block));
        }
    }

    private void addLinkToShadowInports(SimulinkBlock block) {
        if (!SimulinkUtils.isInport((SimulinkBlock)block)) {
            return;
        }
        String index = SimulinkUtils.getPortParameterOrDefault((SimulinkBlock)block);
        for (SimulinkBlock port : SimulinkUtils.findInPortBlocks((SimulinkBlock)block.getParent(), (String)index)) {
            if (port.equals(block)) continue;
            this.storeTypeLink(new SimulinkTypeLink(port, block));
        }
    }

    private void addLinkFromPredecessorToInport(SimulinkBlock block) {
        if (!SimulinkUtils.isInport((SimulinkBlock)block)) {
            return;
        }
        if (block.getParent() == block.getModel()) {
            return;
        }
        SimulinkInPort inport = SimulinkUtils.resolveInportOfSubsystemInportBlock((SimulinkBlock)block);
        SimulinkLine inLine = inport.getLine();
        if (inLine == null) {
            return;
        }
        SimulinkOutPort predecessorPort = inLine.getSrcPort();
        if (predecessorPort == null) {
            return;
        }
        SimulinkBlock predecessorBlock = predecessorPort.getBlock();
        String sourcePortIndex = predecessorPort.getIndex();
        if (predecessorBlock.getOutPorts().size() > 1) {
            this.storeTypeLink(new SimulinkTypeLink(predecessorBlock, block, sourcePortIndex, ""));
        } else {
            this.storeTypeLink(new SimulinkTypeLink(predecessorBlock, block));
        }
    }

    private void addLinksForOutportBlock(SimulinkBlock block) {
        SimulinkOutPort parentOutPort;
        if (!SimulinkUtils.isOutport((SimulinkBlock)block)) {
            return;
        }
        String index = SimulinkUtils.getPortParameterOrDefault((SimulinkBlock)block);
        if (block.getParent() != block.getModel()) {
            this.storeTypeLink(new SimulinkTypeLink(block, block.getParent(), "", index));
        }
        if ((parentOutPort = block.getParent().getOutPort(index)) == null) {
            return;
        }
        for (SimulinkBlock successor : SimulinkNavigationUtils.getSuccessorsWithBackPropagation(parentOutPort)) {
            this.storeTypeLink(new SimulinkTypeLink(successor, block));
        }
    }

    private void addStateflowLinks(SimulinkBlock block) {
        if (block.getParent() != null && block.getParent().getParent() != null && block.getParent().getParent().isStateflowChartBlock() && SimulinkUtils.isOutport((SimulinkBlock)block)) {
            List<SimulinkBlock> parentOutPorts = block.getParent().getParent().getSubBlocks().stream().filter(m -> m.getName().equals(block.getName())).toList();
            for (SimulinkBlock outPort : parentOutPorts) {
                this.storeTypeLink(new SimulinkTypeLink(block, outPort));
            }
        }
    }

    private void storeTypeLink(SimulinkTypeLink link) {
        this.typeLinks.put((Object)link.getSender(), (Object)link);
    }
}

