/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type.dimensions;

import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.model.SimulinkMatrix;
import org.conqat.lib.simulink.model.SimulinkMatrixFactory;

public final class SimulinkDimensionUtils {
    static Optional<SimulinkMatrix> getLargestMatrixFromConstantValues(Set<String> values, boolean vectorAs1D) {
        Set matrices = SimulinkMatrixFactory.createMatrixFromValues(values, (boolean)vectorAs1D);
        return SimulinkDimensionUtils.selectLargestMatrix(matrices);
    }

    static Optional<SimulinkMatrix> getLargestCommonSignalDimension(Set<SimulinkMatrix> dimensions) {
        Optional<SimulinkMatrix> largestMatrix = SimulinkDimensionUtils.selectLargestMatrix(dimensions);
        if (largestMatrix.isEmpty()) {
            return Optional.empty();
        }
        if (dimensions.stream().allMatch(m -> m.expandableTo((SimulinkMatrix)largestMatrix.get()))) {
            return largestMatrix;
        }
        return Optional.empty();
    }

    static Optional<SimulinkMatrix> selectLargestMatrix(Set<SimulinkMatrix> matrices) {
        return matrices.stream().max(Comparator.comparing(SimulinkMatrix::getNumberOfRows).thenComparing(SimulinkMatrix::getNumberOfColumns));
    }

    static boolean haveEqualDimension(SimulinkMatrix m1, SimulinkMatrix m2) {
        return m1.getNumberOfRows() == m2.getNumberOfRows() && m1.getNumberOfColumns() == m2.getNumberOfColumns();
    }

    private SimulinkDimensionUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

