/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type.signal_labels;

import com.google.common.collect.Multimap;
import com.teamscale.index.simulink.signal_type.SimulinkLibraryLoader;
import com.teamscale.index.simulink.signal_type.SimulinkPropagationUtils;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLink;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLinkExtractor;
import com.teamscale.index.simulink.signal_type.signal_labels.SimulinkSignalLabelResolver;
import com.teamscale.index.simulink.signal_type.signal_labels.SimulinkSignalLabelUpdater;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.util.SimulinkUtils;

class SimulinkSignalLabelResolverFromInput {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SimulinkPropagatedSignalLabels propagatedSignalLabels;
    private final SimulinkLibraryLoader libraryLoader;
    private final SimulinkSignalLabelUpdater updater;
    private final Set<SimulinkBlock> visitedBlocks = new HashSet<SimulinkBlock>();
    private final Map<String, SimulinkSignalLabelResolver> resolvedSignalLabelsForEmbeddedModels;

    public SimulinkSignalLabelResolverFromInput(SimulinkLibraryLoader libraryLoader, SimulinkPropagatedSignalLabels propagatedSignalLabels, Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks, Map<String, SimulinkSignalLabelResolver> resolvedSignalLabelsForEmbeddedModels) {
        this.libraryLoader = libraryLoader;
        this.propagatedSignalLabels = propagatedSignalLabels;
        this.resolvedSignalLabelsForEmbeddedModels = resolvedSignalLabelsForEmbeddedModels;
        this.updater = new SimulinkSignalLabelUpdater(propagatedSignalLabels, typeLinks);
    }

    public void resolveSignalLabels(SimulinkModel model) throws StorageException {
        List blocks = SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false);
        this.visitedBlocks.add((SimulinkBlock)model);
        this.resolveSignalLabels(blocks);
    }

    private void resolveSignalLabels(List<SimulinkBlock> blocks) throws StorageException {
        long previousHash = -1L;
        while (true) {
            this.updater.setBlocksUpdated(false);
            this.resolveSignalLabelsFromInput(blocks);
            this.visitedBlocks.clear();
            if (!this.updater.hasBeenUpdated()) {
                return;
            }
            long currentHash = this.updater.calculateResolvedInformationHash();
            if (currentHash == previousHash) {
                return;
            }
            previousHash = currentHash;
        }
    }

    private void resolveSignalLabelsFromInput(List<SimulinkBlock> blocks) throws StorageException {
        for (SimulinkBlock block : blocks) {
            this.resolveSignalLabelsFromInput(block);
        }
    }

    private void resolveSignalLabelsFromInput(SimulinkBlock block) throws StorageException {
        if (!this.needsUpdate(block)) {
            return;
        }
        this.visitedBlocks.add(block);
        if (SimulinkUtils.referencesCustomLibrary((SimulinkBlock)block)) {
            this.resolveSignalLabelsForLibrary(block);
        } else if (SimulinkUtils.isSubsystemReferenceBlock((SimulinkBlock)block)) {
            this.resolveSignalLabelsForSubsystemReferenceBlock(block);
        } else if (block.isOfType("SubSystem")) {
            this.setInportSignalLabelsForSubsystem(block);
        } else if (SimulinkTypeLinkExtractor.BLOCK_TYPES_ACCEPTING_PROPAGATED_SIGNAL_LABEL.contains(block.getType())) {
            this.propagateEnteredSignalLabelToBlock(block);
        }
    }

    private boolean needsUpdate(SimulinkBlock block) {
        if (this.visitedBlocks.contains(block)) {
            return false;
        }
        if (block.getOutPorts().isEmpty()) {
            return !this.propagatedSignalLabels.contains(block);
        }
        for (SimulinkOutPort outport : block.getOutPorts()) {
            String portIndex = outport.getIndex();
            if (this.propagatedSignalLabels.contains(block, portIndex)) continue;
            return true;
        }
        return false;
    }

    private void resolveSignalLabelsForLibrary(SimulinkBlock block) throws StorageException {
        List<SimulinkModel> libraryModels = this.libraryLoader.loadLibraryFromReferenceBlock(block);
        if (libraryModels.isEmpty()) {
            this.updater.updateInformation(block, null);
            return;
        }
        for (SimulinkModel libraryModel : libraryModels) {
            SimulinkPropagatedSignalLabels alreadyResolvedSignals = this.getAlreadyResolvedSignalsForLibrary(libraryModel);
            SimulinkSignalLabelResolver librarySignalLabelAnalyser = new SimulinkSignalLabelResolver(libraryModel, this.libraryLoader, alreadyResolvedSignals, this.resolvedSignalLabelsForEmbeddedModels, SimulinkPropagationUtils.extractReferencedBlock(libraryModel, block.getSourceBlockName()));
            this.passInformationToInPortsOfLibrary(block, librarySignalLabelAnalyser);
            librarySignalLabelAnalyser.resolveSignalLabels();
            this.fetchInformationFromOutPortsOfLibrary(block, librarySignalLabelAnalyser);
            this.resolvedSignalLabelsForEmbeddedModels.put(libraryModel.getUniformPath(), librarySignalLabelAnalyser);
        }
    }

    private void resolveSignalLabelsForSubsystemReferenceBlock(SimulinkBlock subsystemReferenceBlock) throws StorageException {
        List<SimulinkModel> targetModels = this.libraryLoader.loadReferencedModelFromSubsystemReferenceBlock(subsystemReferenceBlock);
        if (targetModels.isEmpty()) {
            this.updater.updateInformation(subsystemReferenceBlock, null);
            return;
        }
        for (SimulinkModel targetModel : targetModels) {
            SimulinkPropagatedSignalLabels alreadyResolvedSignals = this.getAlreadyResolvedSignalsForLibrary(targetModel);
            SimulinkSignalLabelResolver targetModelSignalLabelAnalyser = new SimulinkSignalLabelResolver(targetModel, this.libraryLoader, alreadyResolvedSignals, this.resolvedSignalLabelsForEmbeddedModels, (SimulinkBlock)targetModel);
            this.passInformationToInPortsOfLibrary(subsystemReferenceBlock, targetModelSignalLabelAnalyser);
            targetModelSignalLabelAnalyser.resolveSignalLabels();
            this.fetchInformationFromOutPortsOfLibrary(subsystemReferenceBlock, targetModelSignalLabelAnalyser);
            this.resolvedSignalLabelsForEmbeddedModels.put(targetModel.getUniformPath(), targetModelSignalLabelAnalyser);
        }
    }

    private void setInportSignalLabelsForSubsystem(SimulinkBlock block) {
        for (SimulinkInPort inPort : block.getInPorts()) {
            String resolvedSignalLabel = this.propagatedSignalLabels.getInputSignalLabels(block, inPort.getIndex());
            if (resolvedSignalLabel == null) continue;
            for (SimulinkBlock inport : SimulinkUtils.findInPortBlocks((SimulinkBlock)block, (String)inPort.getIndex())) {
                this.updater.updateInformation(inport, resolvedSignalLabel);
            }
        }
    }

    private void propagateEnteredSignalLabelToBlock(SimulinkBlock block) {
        if (block.getInPorts().size() > 1) {
            LOGGER.warn("Blocks which support signal label propagation are expected to only have one incoming signal. The following block has multiple incoming signals: " + block.getNamePretty());
        }
        for (SimulinkInPort inport : block.getInPorts()) {
            Optional enteredSignalLabel;
            SimulinkLine inline = inport.getLine();
            if (inline == null || (enteredSignalLabel = inline.getName()).isEmpty()) continue;
            this.updater.updateInformation(block, (String)enteredSignalLabel.get());
        }
    }

    private SimulinkPropagatedSignalLabels getAlreadyResolvedSignalsForLibrary(SimulinkModel libraryModel) {
        SimulinkSignalLabelResolver simulinkSignalLabelResolver = this.resolvedSignalLabelsForEmbeddedModels.get(libraryModel.getUniformPath());
        if (simulinkSignalLabelResolver == null) {
            return new SimulinkPropagatedSignalLabels();
        }
        return simulinkSignalLabelResolver.getPropagatedSignalLabels();
    }

    private void passInformationToInPortsOfLibrary(SimulinkBlock libraryBlock, SimulinkSignalLabelResolver librarySignalLabelAnalyser) {
        for (SimulinkInPort inPort : libraryBlock.getInPorts()) {
            String resolvedSignalLabel = this.propagatedSignalLabels.getInputSignalLabels(libraryBlock, inPort.getIndex());
            librarySignalLabelAnalyser.addResolvedInportSignalLabels(inPort.getIndex(), resolvedSignalLabel);
        }
    }

    private void fetchInformationFromOutPortsOfLibrary(SimulinkBlock libraryBlock, SimulinkSignalLabelResolver libraryDataTypeAnalyser) {
        Map<String, String> outputSignalLabelsOfLibrary = libraryDataTypeAnalyser.getResolvedOutPortSignalLabels();
        for (Map.Entry<String, String> entry : outputSignalLabelsOfLibrary.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.updater.updateInformation(libraryBlock, key, value);
        }
    }
}

