/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;

public class PartitionLastUpdatedStoreFeature {
    private final ConvenientStore store;
    private final byte[] prefix;

    public PartitionLastUpdatedStoreFeature(IStore store, byte[] prefix) {
        this.store = new ConvenientStore(store);
        this.prefix = prefix;
    }

    public void setPartitionsLastUpdated(PairList<String, CommitDescriptor> partitionsAndLastUpdatedCommit) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        PairList partitionAndLastUpdateEntryMap = new PairList();
        for (int i = 0; i < partitionsAndLastUpdatedCommit.size(); ++i) {
            String partition = (String)partitionsAndLastUpdatedCommit.getFirst(i);
            CommitDescriptor commit = (CommitDescriptor)partitionsAndLastUpdatedCommit.getSecond(i);
            partitionAndLastUpdateEntryMap.add((Object)this.makePartitionUpdatedKey(abbreviator, partition), (Object)PartitionLastUpdatedStoreFeature.serializeCommitDescriptor(abbreviator, commit));
        }
        this.store.put(partitionAndLastUpdateEntryMap);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<String, CommitDescriptor> getPartitionToLastUploadMap(Collection<String> partitions) throws StorageException {
        HashMap<String, CommitDescriptor> map = new HashMap<String, CommitDescriptor>();
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        ArrayList<String> partitionsList = new ArrayList<String>(partitions);
        @Nullable List bytes = this.store.get(CollectionUtils.mapWithException(partitionsList, partition -> this.makePartitionUpdatedKey(abbreviator, (String)partition)));
        CollectionUtils.forEachWithException(partitionsList, (Collection)bytes, (partition, value) -> {
            if (value != null) {
                map.put((String)partition, PartitionLastUpdatedStoreFeature.deserializeCommitDescriptor(abbreviator, value));
            }
        });
        return map;
    }

    private static byte @NonNull [] serializeCommitDescriptor(StorageStringAbbreviator abbreviator, CommitDescriptor commit) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(commit.getBranchName())), ByteArrayUtils.longToByteArray((long)commit.getTimestamp())});
    }

    private static @NonNull CommitDescriptor deserializeCommitDescriptor(StorageStringAbbreviator abbreviator, byte[] data) throws StorageException {
        String branch = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)0));
        long timestamp = ByteArrayUtils.getLongFromByteArray((byte[])data, (int)4);
        return new CommitDescriptor(branch, timestamp);
    }

    private byte[] makePartitionUpdatedKey(StorageStringAbbreviator abbreviator, String partition) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{this.prefix, ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(partition))});
    }
}

