/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.assessment;

import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;

public enum ETgaAssessment {
    ADDITION_TESTED_AFTER_LAST_CHANGE(ETestGapState.TESTED_CHURN, ETestGapState.EXECUTED, ETestGapState.UNTESTED_ADDITION),
    ADDITION_EXECUTED_BEFORE_LAST_CHANGE(ETestGapState.UNTESTED_ADDITION, ETestGapState.EXECUTED, ETestGapState.UNTESTED_ADDITION),
    ADDITION_NEVER_EXECUTED(ETestGapState.UNTESTED_ADDITION, ETestGapState.NOT_EXECUTED, ETestGapState.UNTESTED_ADDITION),
    MODIFICATION_TESTED_AFTER_LAST_CHANGE(ETestGapState.TESTED_CHURN, ETestGapState.EXECUTED, ETestGapState.UNTESTED_CHANGE),
    MODIFICATION_EXECUTED_BEFORE_LAST_CHANGE(ETestGapState.UNTESTED_CHANGE, ETestGapState.EXECUTED, ETestGapState.UNTESTED_CHANGE),
    MODIFICATION_NEVER_EXECUTED(ETestGapState.UNTESTED_CHANGE, ETestGapState.NOT_EXECUTED, ETestGapState.UNTESTED_CHANGE),
    UNCHANGED_EXECUTED(ETestGapState.UNCHANGED, ETestGapState.EXECUTED, ETestGapState.UNCHANGED),
    UNCHANGED_NOT_EXECUTED(ETestGapState.UNCHANGED, ETestGapState.NOT_EXECUTED, ETestGapState.UNCHANGED);

    private final ETestGapState testGapState;
    private final ETestGapState executionState;
    private final ETestGapState churnState;

    private ETgaAssessment(ETestGapState testGapState, ETestGapState executionState, ETestGapState churnState) {
        this.testGapState = testGapState;
        this.executionState = executionState;
        this.churnState = churnState;
    }

    public ETestGapState getStateForAssessmentType(ETgaAssessmentType assessmentType) {
        return switch (assessmentType) {
            default -> throw new MatchException(null, null);
            case ETgaAssessmentType.TEST_GAP -> this.testGapState;
            case ETgaAssessmentType.EXECUTION_ONLY -> this.executionState;
            case ETgaAssessmentType.CHURN -> this.churnState;
        };
    }
}

