/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.index;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.index.ArchitecturePathDataRetriever;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.DataRetrieverUtils;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.index.TestInfoFilter;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class FileListDataRetriever
implements ITgaDataRetriever {
    private final List<UniformPath> uniformPaths;
    private final List<String> partitions;
    private final TgaDataRetrieverIndexes dataRetrieverIndexes;
    private final CrossAnnotator crossAnnotator;
    private final @Nullable Map<UniformPath, UniformPath> sourceToArchitecturePathMap;
    private final @Nullable List<CommitDescriptor> codeCommitsOfSourceBranch;
    private final TestInfoFilter testInfoFilter;
    private final CodeScopeAware<Boolean> tgaEnablementPerCodeScope;

    public FileListDataRetriever(List<UniformPath> uniformPaths, List<String> partitions, TgaDataRetrieverIndexes dataRetrieverIndexes, CrossAnnotator crossAnnotator, @Nullable Map<UniformPath, UniformPath> sourceToArchitecturePathMap, @Nullable List<CommitDescriptor> codeCommitsOfSourceBranch, TestInfoFilter testInfoFilter, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) {
        this.uniformPaths = uniformPaths;
        this.partitions = partitions;
        this.dataRetrieverIndexes = dataRetrieverIndexes;
        this.crossAnnotator = crossAnnotator;
        this.sourceToArchitecturePathMap = sourceToArchitecturePathMap;
        this.codeCommitsOfSourceBranch = codeCommitsOfSourceBranch;
        this.testInfoFilter = testInfoFilter;
        this.tgaEnablementPerCodeScope = tgaEnablementPerCodeScope;
    }

    @Override
    public UnassessedTestGapData fetchData(MethodInfoFilter methodInfoFilter) throws StorageException {
        List<AssociatedMethodInfo> methodInfos;
        boolean hasMergeBase;
        boolean bl = hasMergeBase = this.codeCommitsOfSourceBranch != null && this.dataRetrieverIndexes.getMergeBaseMethodInfoIndex() != null;
        if (hasMergeBase) {
            methodInfos = this.dataRetrieverIndexes.getMethodInfoIndex().getAssociatedMethodInfosForExactPathsWithCrossAnnotationInfo(this.uniformPaths);
            methodInfos = DataRetrieverUtils.filterAssociatedMethodInfosToChangesFromCurrentBranch(this.codeCommitsOfSourceBranch, this.dataRetrieverIndexes.getMergeBaseMethodInfoIndex(), this.uniformPaths, methodInfos);
        } else {
            boolean includeCrossAnnotationInformation = this.crossAnnotator.hasCrossAnnotationIndices();
            methodInfos = this.dataRetrieverIndexes.getMethodInfoIndex().getAssociatedMethodInfosForExactPaths(this.uniformPaths, includeCrossAnnotationInformation);
        }
        UnassessedTestGapData unassessedTestGapData = DataRetrieverUtils.createUnassessedTestGapData(methodInfos, this.partitions, this.crossAnnotator, this.dataRetrieverIndexes, methodInfoFilter, this.testInfoFilter, this.tgaEnablementPerCodeScope);
        if (this.sourceToArchitecturePathMap == null) {
            return unassessedTestGapData;
        }
        List<UnassessedTestGapData.UnassessedMethodData> methodsWithArchitecturePaths = ArchitecturePathDataRetriever.changeUniformPathBackToArchitecturePath(unassessedTestGapData, this.sourceToArchitecturePathMap);
        return new UnassessedTestGapData(methodsWithArchitecturePaths);
    }
}

