/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.google.common.collect.Lists;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdMapper;
import com.teamscale.index.testimpact.MethodSet;
import com.teamscale.index.testimpact.PartitionedTestSet;
import com.teamscale.index.testimpact.SingleParentUpdateStrategy;
import com.teamscale.index.testimpact.TestsToMethodsMapIndexUpdate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class MultipleParentUpdateStrategy
extends SingleParentUpdateStrategy {
    private final List<CoverageUnitToMethodsMapIndex> parentTestsToMethodsMapIndices;
    private final MethodIdMapper methodIdUpdateMaps;
    private final List<PartitionAndPath> testDelta;
    private final Map<MethodId, PartitionedTestSet> mappingUpdater = new HashMap<MethodId, PartitionedTestSet>();

    MultipleParentUpdateStrategy(IndexDelta<UniformPath> methodInfoIndexDelta, List<CoverageUnitToMethodsMapIndex> parentTestsToMethodsMapIndices, MethodIdMapper methodIdUpdateMaps, Set<PartitionAndPath> updatedCoverageUnits, Set<PartitionAndPath> testDelta) {
        super(methodInfoIndexDelta, parentTestsToMethodsMapIndices.getFirst(), methodIdUpdateMaps, updatedCoverageUnits);
        this.parentTestsToMethodsMapIndices = parentTestsToMethodsMapIndices;
        this.methodIdUpdateMaps = methodIdUpdateMaps;
        this.testDelta = new ArrayList<PartitionAndPath>(CollectionUtils.differenceSet(testDelta, (Collection[])new Collection[]{updatedCoverageUnits}));
    }

    @Override
    public Set<PartitionAndPath> calculateUpdateAndStore(CoverageUnitToMethodsMapIndex coverageUnitToMethodsMapIndex) throws StorageException {
        Set<PartitionAndPath> updatedTests = super.calculateUpdateAndStore(coverageUnitToMethodsMapIndex);
        List testDeltaChunks = Lists.partition(this.testDelta, (int)MAX_TEST_CHUNKS);
        for (List testDeltaChunk : testDeltaChunks) {
            Map<PartitionAndPath, MethodSet> updatedTestsToMethodsMapping = this.mergeTestToMethodsMappingForChunk(testDeltaChunk);
            TestsToMethodsMapIndexUpdate update = new TestsToMethodsMapIndexUpdate(this.mappingUpdater, false, this.methodIdUpdateMaps.getDeletedMethodIds(0), updatedTestsToMethodsMapping);
            coverageUnitToMethodsMapIndex.storeTestsToMethodsMapIndexUpdate(update);
            updatedTests.addAll(update.testToMethodLocations.keySet());
        }
        return updatedTests;
    }

    private Map<PartitionAndPath, MethodSet> mergeTestToMethodsMappingForChunk(List<PartitionAndPath> testDeltaChunk) throws StorageException {
        HashMap<PartitionAndPath, MethodSet> updatedTestsToMethodsMapping = new HashMap<PartitionAndPath, MethodSet>();
        for (int parentIndex = 0; parentIndex < this.parentTestsToMethodsMapIndices.size(); ++parentIndex) {
            Map<PartitionAndPath, MethodSet> methodsCoveredByTests = this.parentTestsToMethodsMapIndices.get(parentIndex).getTestEntries(testDeltaChunk);
            this.applyMethodLocationKeyChanges(parentIndex, methodsCoveredByTests.values());
            if (parentIndex == 0) {
                updatedTestsToMethodsMapping.putAll(methodsCoveredByTests);
                continue;
            }
            methodsCoveredByTests.forEach((test, methods) -> this.updateMethodSet((Map<PartitionAndPath, MethodSet>)updatedTestsToMethodsMapping, (PartitionAndPath)test, (MethodSet)methods));
        }
        return updatedTestsToMethodsMapping;
    }

    private void applyMethodLocationKeyChanges(int parentIndex, Collection<MethodSet> coveredMethodSets) throws StorageException {
        for (MethodSet parentMethodSet : coveredMethodSets) {
            parentMethodSet.transform(parentMethodId -> this.methodIdUpdateMaps.translateToNewMethodId(parentIndex, (MethodId)parentMethodId));
        }
    }

    private void updateMethodSet(Map<PartitionAndPath, MethodSet> updatedTestsToMethodsMapping, PartitionAndPath test, MethodSet methodSet) {
        if (!updatedTestsToMethodsMapping.containsKey(test)) {
            updatedTestsToMethodsMapping.put(test, methodSet);
            for (MethodId method : methodSet) {
                PartitionedTestSet partitionAndTests = this.mappingUpdater.computeIfAbsent(method, key -> new PartitionedTestSet());
                partitionAndTests.add(test);
            }
            return;
        }
        MethodSet updatedMethodSet = updatedTestsToMethodsMapping.get(test);
        MethodSet newlyExecutedMethods = MethodSet.getRelativeComplement(methodSet, updatedMethodSet);
        for (MethodId method : newlyExecutedMethods) {
            PartitionedTestSet partitionAndTests = this.mappingUpdater.computeIfAbsent(method, key -> new PartitionedTestSet());
            partitionAndTests.add(test);
        }
        if (!newlyExecutedMethods.isEmpty()) {
            updatedTestsToMethodsMapping.put(test, MethodSet.merge(updatedMethodSet, methodSet));
        }
    }
}

