/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.utils.AsyncServiceJobRun;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class TestMinimizationJobRun
extends AsyncServiceJobRun {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="coverage")
    private double retainedTestCoverage;
    @JsonProperty(value="testCount")
    private int testCount;
    @JsonProperty(value="testListHash")
    private @Nullable String testListHash;
    @JsonProperty(value="testDurationMs")
    private long testDurationSecondsMs;

    private TestMinimizationJobRun(String id, String username, long startTimestamp, String jobDescription, List<AsyncServiceJobRun.ProcessProgress> progressStack, double retainedTestCoverage, int testCount, long testDurationSecondsMs, @Nullable String testListHash, AsyncServiceJobRun.EJobStatus jobStatus) {
        super(id, username, startTimestamp, jobDescription, progressStack, jobStatus);
        this.retainedTestCoverage = retainedTestCoverage;
        this.testDurationSecondsMs = testDurationSecondsMs;
        this.testCount = testCount;
        this.testListHash = testListHash;
    }

    public TestMinimizationJobRun(String username, long startTimestamp, String description) {
        super(username, startTimestamp, description);
        this.retainedTestCoverage = 0.0;
        this.testDurationSecondsMs = 0L;
        this.testCount = 0;
        this.testListHash = null;
    }

    private double getRetainedTestCoverage() {
        return this.retainedTestCoverage;
    }

    public int getTestCount() {
        return this.testCount;
    }

    public long getTestDurationMs() {
        return this.testDurationSecondsMs;
    }

    public @Nullable String getTestListHash() {
        return this.testListHash;
    }

    public TestMinimizationJobRun withDescription(String description) {
        return new TestMinimizationJobRun(this.getId(), this.getUsername(), this.getStartTimestamp(), description, this.getProgressStack(), this.getRetainedTestCoverage(), this.getTestCount(), this.getTestDurationMs(), this.getTestListHash(), this.getStatus());
    }

    public TestMinimizationJobRun withProgressStack(List<AsyncServiceJobRun.ProcessProgress> progressStack) {
        return new TestMinimizationJobRun(this.getId(), this.getUsername(), this.getStartTimestamp(), this.getDescription(), progressStack, this.getRetainedTestCoverage(), this.getTestCount(), this.getTestDurationMs(), this.getTestListHash(), this.getStatus());
    }

    public TestMinimizationJobRun withJobStatus(AsyncServiceJobRun.EJobStatus jobStatus) {
        return new TestMinimizationJobRun(this.getId(), this.getUsername(), this.getStartTimestamp(), this.getDescription(), this.getProgressStack(), this.getRetainedTestCoverage(), this.getTestCount(), this.getTestDurationMs(), this.getTestListHash(), jobStatus);
    }

    public TestMinimizationJobRun withRetainedCoverage(double retainedTestCoverage) {
        return new TestMinimizationJobRun(this.getId(), this.getUsername(), this.getStartTimestamp(), this.getDescription(), this.getProgressStack(), retainedTestCoverage, this.getTestCount(), this.getTestDurationMs(), this.getTestListHash(), this.getStatus());
    }

    public TestMinimizationJobRun withTestCount(int testCount) {
        return new TestMinimizationJobRun(this.getId(), this.getUsername(), this.getStartTimestamp(), this.getDescription(), this.getProgressStack(), this.getRetainedTestCoverage(), testCount, this.getTestDurationMs(), this.getTestListHash(), this.getStatus());
    }

    public TestMinimizationJobRun withTestDuration(long testDurationMs) {
        return new TestMinimizationJobRun(this.getId(), this.getUsername(), this.getStartTimestamp(), this.getDescription(), this.getProgressStack(), this.getRetainedTestCoverage(), this.getTestCount(), testDurationMs, this.getTestListHash(), this.getStatus());
    }

    public TestMinimizationJobRun withStartTimestamp(long startTimestamp) {
        return new TestMinimizationJobRun(this.getId(), this.getUsername(), startTimestamp, this.getDescription(), this.getProgressStack(), this.getRetainedTestCoverage(), this.getTestCount(), this.getTestDurationMs(), this.getTestListHash(), this.getStatus());
    }

    public TestMinimizationJobRun withTestListHash(@Nullable String testListHash) {
        return new TestMinimizationJobRun(this.getId(), this.getUsername(), this.getStartTimestamp(), this.getDescription(), this.getProgressStack(), this.getRetainedTestCoverage(), this.getTestCount(), this.getTestDurationMs(), testListHash, this.getStatus());
    }
}

