/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor;

import com.teamscale.index.tests.extractor.ITestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.boosttest.BoostTestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.cmockatest.CMockaTestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.custom.CustomTestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.googletest.GoogleTestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.junit.JUnitTestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.mathworks.MathWorksClassBasedTestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.mathworks.MathWorksFunctionBasedTestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.nunit_mstest.CsTestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.pytest_unittest.PytestAndUnittestTestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.xctest.XCTestObjectiveCTestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.xctest.XCTestSwiftTestCaseExtractionStrategy;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.collections.PairList;

public class TestCaseExtractionStrategyFactory {
    public static List<ITestCaseExtractionStrategy> getStrategies(ELanguage language, PairList<String, String> testDetectionPatterns) {
        ArrayList<ITestCaseExtractionStrategy> strategies = new ArrayList<ITestCaseExtractionStrategy>(TestCaseExtractionStrategyFactory.getLanguageSpecificStrategies(language));
        strategies.add(new CustomTestCaseExtractionStrategy(testDetectionPatterns));
        return strategies;
    }

    private static List<ITestCaseExtractionStrategy> getLanguageSpecificStrategies(ELanguage language) {
        return switch (language) {
            case ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C -> List.of(new GoogleTestCaseExtractionStrategy(), new CMockaTestCaseExtractionStrategy(), new BoostTestCaseExtractionStrategy());
            case ELanguage.PYTHON -> List.of(new PytestAndUnittestTestCaseExtractionStrategy());
            case ELanguage.JAVA -> List.of(new JUnitTestCaseExtractionStrategy());
            case ELanguage.CS -> List.of(new CsTestCaseExtractionStrategy(CsTestCaseExtractionStrategy.NUNIT_TEST_ATTRIBUTE_NAMES), new CsTestCaseExtractionStrategy(CsTestCaseExtractionStrategy.MSTEST_TEST_ATTRIBUTE_NAMES), new CsTestCaseExtractionStrategy(CsTestCaseExtractionStrategy.XUNIT_TEST_ATTRIBUTE_NAMES));
            case ELanguage.MATLAB -> List.of(new MathWorksClassBasedTestCaseExtractionStrategy(), new MathWorksFunctionBasedTestCaseExtractionStrategy());
            case ELanguage.SWIFT -> List.of(new XCTestSwiftTestCaseExtractionStrategy());
            case ELanguage.OBJECTIVE_C -> List.of(new XCTestObjectiveCTestCaseExtractionStrategy());
            default -> List.of();
        };
    }
}

