/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import com.teamscale.index.tracking.algorithm.TrackedFindingWithContext;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.algo.MaxWeightMatching;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public abstract class TrackedFindingContextMatchingStrategyBase {
    private static final Duration MAX_MATCHING_TIMEOUT = Duration.ofSeconds(Integer.getInteger("com.teamscale.findings-tracking.max-match-seconds", 60).intValue());
    private static final Logger LOGGER = LogManager.getLogger();

    protected abstract PairList<TrackedFindingWithContext, TrackedFindingWithContext> performMatching(UnmodifiableSet<TrackedFindingWithContext> var1, UnmodifiableSet<TrackedFindingWithContext> var2);

    protected static PairList<TrackedFindingWithContext, TrackedFindingWithContext> calculateTimeBoundedMatching(List<TrackedFindingWithContext> oldFindings, List<TrackedFindingWithContext> newFindings, MaxWeightMatching.IWeightProvider<TrackedFindingWithContext, TrackedFindingWithContext> weightProvider) {
        PairList result = new PairList();
        if (oldFindings.size() == 1 && newFindings.size() == 1) {
            result.add((Object)oldFindings.getFirst(), (Object)newFindings.getFirst());
            return result;
        }
        final long maxTime = System.currentTimeMillis() + MAX_MATCHING_TIMEOUT.toMillis();
        MaxWeightMatching<TrackedFindingWithContext, TrackedFindingWithContext> matching = new MaxWeightMatching<TrackedFindingWithContext, TrackedFindingWithContext>(){

            protected void updateProgressTick() {
                if (System.currentTimeMillis() > maxTime) {
                    throw new MatchingTimeExceededException();
                }
            }
        };
        try {
            matching.calculateMatching(oldFindings, newFindings, weightProvider, result);
        }
        catch (MatchingTimeExceededException e) {
            LOGGER.warn("Aborted max weight matching due to timeout for {} old findings and {} new findings. Falling back to greedy heuristic!", (Object)oldFindings.size(), (Object)newFindings.size());
            result.clear();
            matching.greedyMatch(result);
        }
        return result;
    }

    protected static PairList<TrackedFindingWithContext, TrackedFindingWithContext> removeDuplicateIdsFromMatching(PairList<TrackedFindingWithContext, TrackedFindingWithContext> trackedFindings) {
        HashSet idsInUse = new HashSet();
        return (PairList)trackedFindings.stream().filter(findingsPair -> idsInUse.add(((TrackedFindingWithContext)findingsPair.getFirst()).getFinding().getId())).collect(PairList.toPairList());
    }

    private static class MatchingTimeExceededException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private MatchingTimeExceededException() {
        }
    }
}

