/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.usage;

import com.teamscale.index.testgap.MethodLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

@Index(name="method-usage-count", options={EStorageOption.BRANCHED})
public class MethodUsageCountIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "method-usage-count";
    private final ValueIndex<Long> delegate;

    public MethodUsageCountIndex(IStore store) {
        this.delegate = ValueIndex.forLong((IStore)store);
    }

    public synchronized void addUsageCountDeltas(PairList<MethodLocation, Long> locationAndDeltas) throws StorageException {
        this.delegate.setOrMergeValues(locationAndDeltas.mapFirst(MethodLocation::toIndexKey), Long::sum);
    }

    public void applyMethodLocationChanges(Map<String, String> oldToNewMethodLocations) throws StorageException {
        List oldMethodLocations = CollectionUtils.filter(oldToNewMethodLocations.keySet(), Objects::nonNull);
        List existingMethodUsageCounts = this.delegate.getValues(oldMethodLocations);
        ArrayList<String> methodLocationsToRemove = new ArrayList<String>();
        PairList newMethodLocationsAndMethodUsages = new PairList();
        for (int i = 0; i < oldMethodLocations.size(); ++i) {
            Long methodUsageCount = (Long)existingMethodUsageCounts.get(i);
            if (methodUsageCount == null) continue;
            String oldMethodLocation = (String)oldMethodLocations.get(i);
            methodLocationsToRemove.add(oldMethodLocation);
            String newMethodLocation = oldToNewMethodLocations.get(oldMethodLocation);
            if (newMethodLocation == null) continue;
            newMethodLocationsAndMethodUsages.add((Object)newMethodLocation, (Object)methodUsageCount);
        }
        this.delegate.removeValues(methodLocationsToRemove);
        this.delegate.setValues(newMethodLocationsAndMethodUsages);
    }

    public PairList<String, Long> getMethodUsageCounts(String uniformPath) throws StorageException {
        return this.delegate.getEntriesStartingWith(uniformPath);
    }
}

