/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.user;

import com.teamscale.index.user.EAvatarSize;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="avatars", options={EStorageOption.BACKUP}, valueClasses={byte[].class})
public class AvatarIndex
extends IndexBase
implements IGlobalIndex {
    public static final String INDEX_NAME = "avatars";
    private static final String DEFAULT_AVATAR_KEY = "default-image";
    private static final String SEPARATOR = "|";

    public AvatarIndex(IStore store) {
        super(store);
    }

    public byte[] getImage(String username, EAvatarSize size) throws StorageException {
        String key = AvatarIndex.getKey(username, size);
        return this.store.getWithString(key);
    }

    private static String getKey(String username, EAvatarSize size) {
        return AvatarIndex.getKey(username, size.name());
    }

    private static String getKey(String username, String secondaryPart) {
        return username + SEPARATOR + secondaryPart;
    }

    public void putImage(String username, EAvatarSize size, byte[] image) throws StorageException {
        String key = AvatarIndex.getKey(username, size);
        this.store.putWithString(key, image);
    }

    public void putDefaultImage(String username, byte[] image) throws StorageException {
        this.store.putWithString(AvatarIndex.getKey(username, DEFAULT_AVATAR_KEY), image);
    }

    public byte[] getDefaultImage(String username) throws StorageException {
        return this.store.getWithString(AvatarIndex.getKey(username, DEFAULT_AVATAR_KEY));
    }
}

