/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMAssert;

public abstract class StringPoolSerializer {
    static final int NULL_MARKER = -1;
    private final List<String> stringPool = new ArrayList<String>();
    private final Map<String, Integer> stringPoolIndex = new HashMap<String, Integer>();

    public void addString(String string) {
        if (string != null && !this.stringPoolIndex.containsKey(string)) {
            this.stringPoolIndex.put(string, this.stringPool.size());
            this.stringPool.add(string);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] serialize() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                this.serializeStringPool(dos);
                this.serializeData(dos);
                dos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new AssertionError("Working in memory should not allow this!", e);
        }
    }

    protected abstract void serializeData(DataOutputStream var1) throws IOException;

    protected void writeString(String string, DataOutputStream dos) throws IOException {
        if (string == null) {
            dos.writeInt(-1);
            return;
        }
        Integer index = this.stringPoolIndex.get(string);
        CCSMAssert.isNotNull((Object)index, (String)"String must be inserted to the pool before-hand!");
        dos.writeInt(index);
    }

    private void serializeStringPool(DataOutputStream dos) throws IOException {
        dos.writeInt(this.stringPool.size());
        for (String string : this.stringPool) {
            dos.writeUTF(string);
        }
    }
}

