/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.utils;

import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.engine.persistence.store.util.StringAbbreviationSerializerBase;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

public class TeamscaleIssueIdSerializer
extends StringAbbreviationSerializerBase<TeamscaleIssueId> {
    public TeamscaleIssueIdSerializer(StorageStringAbbreviator stringAbbreviator, List<TeamscaleIssueId> locations) throws StorageException {
        super(stringAbbreviator, locations);
    }

    public List<String> getStringsToAbbreviate(@Nullable TeamscaleIssueId element) {
        if (element == null) {
            return Collections.emptyList();
        }
        return List.of(element.getConnectorId());
    }

    protected byte @NonNull [] serializeToByteArrayInternal(TeamscaleIssueId element, Map<String, Integer> abbreviationMap) {
        byte[] internalIdBytes = StringUtils.stringToBytes((String)element.getInternalId());
        byte[] externalIdBytes = StringUtils.stringToBytes((String)element.getExternalId());
        return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviationMap.get(element.getConnectorId())), ByteArrayUtils.intToByteArray((int)internalIdBytes.length), internalIdBytes, ByteArrayUtils.intToByteArray((int)externalIdBytes.length), externalIdBytes});
    }
}

