/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveMap<T>
implements Map<String, T> {
    private final Map<String, T> delegateMap = new HashMap<String, T>();

    @Override
    public int size() {
        return this.delegateMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegateMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegateMap.containsKey(CaseInsensitiveMap.preprocessKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegateMap.containsValue(value);
    }

    @Override
    public T get(Object key) {
        return this.delegateMap.get(CaseInsensitiveMap.preprocessKey(key));
    }

    @Override
    public T put(String key, T value) {
        return this.delegateMap.put(CaseInsensitiveMap.preprocessKey(key), value);
    }

    @Override
    public T remove(Object key) {
        return this.delegateMap.remove(CaseInsensitiveMap.preprocessKey(key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> m) {
        for (Map.Entry<String, T> entry : m.entrySet()) {
            this.delegateMap.put(CaseInsensitiveMap.preprocessKey(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegateMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.delegateMap.keySet();
    }

    @Override
    public Collection<T> values() {
        return this.delegateMap.values();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.delegateMap.entrySet();
    }

    private static String preprocessKey(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof String) {
            return ((String)key).toLowerCase();
        }
        throw new IllegalArgumentException("Only keys of type String allowed");
    }

    public String toString() {
        return this.delegateMap.toString();
    }
}

