/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collections;
import java.util.Map;
import java.util.SequencedMap;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableSequencedCollection;
import org.conqat.lib.commons.collections.UnmodifiableSequencedMap;
import org.conqat.lib.commons.collections.UnmodifiableSequencedSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;

final class UnmodifiableSequencedMapImpl<K, V>
implements UnmodifiableSequencedMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final SequencedMap<K, V> sequencedMap;

    public UnmodifiableSequencedMapImpl(SequencedMap<K, V> sequencedMap) {
        this.sequencedMap = Collections.unmodifiableSequencedMap(sequencedMap);
    }

    @Override
    public UnmodifiableSequencedMap<K, V> reversed() {
        return UnmodifiableSequencedMap.of(this.sequencedMap.reversed());
    }

    @Override
    public UnmodifiableSequencedSet<K> sequencedKeySet() {
        return UnmodifiableSequencedSet.of(this.sequencedMap.sequencedKeySet());
    }

    @Override
    public UnmodifiableSequencedCollection<V> sequencedValues() {
        return UnmodifiableSequencedCollection.of(this.sequencedMap.sequencedValues());
    }

    @Override
    public UnmodifiableSequencedSet<Map.Entry<K, V>> sequencedEntrySet() {
        return UnmodifiableSequencedSet.of(this.sequencedMap.sequencedEntrySet());
    }

    @Override
    public @NonNull UnmodifiableSet<K> keySet() {
        return UnmodifiableSet.of(this.sequencedMap.keySet());
    }

    @Override
    public @NonNull UnmodifiableCollection<V> values() {
        return UnmodifiableCollection.of(this.sequencedMap.values());
    }

    @Override
    public @NonNull UnmodifiableSet<Map.Entry<K, V>> entrySet() {
        return UnmodifiableSet.of(this.sequencedMap.entrySet());
    }

    @Override
    public int size() {
        return this.sequencedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sequencedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.sequencedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.sequencedMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.sequencedMap.get(key);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.sequencedMap.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.sequencedMap.forEach(action);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.sequencedMap.firstEntry();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.sequencedMap.lastEntry();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnmodifiableSequencedMapImpl) {
            UnmodifiableSequencedMapImpl that = (UnmodifiableSequencedMapImpl)o;
            return this.sequencedMap.equals(that.sequencedMap);
        }
        return this.sequencedMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.sequencedMap.hashCode();
    }

    public String toString() {
        return this.sequencedMap.toString();
    }
}

