/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.function.FunctionWithException;

public class FutureWithException<T, E extends Exception>
implements Future<T> {
    private final Future<T> delegate;
    private final Class<E> expectedException;

    public FutureWithException(Future<T> delegate, Class<E> expectedException) {
        this.delegate = delegate;
        this.expectedException = expectedException;
    }

    public static <T, E extends Exception> FutureWithException<T, E> resolved(T resolved) {
        FutureWithException<T, Exception> result = new FutureWithException<T, Exception>(CompletableFuture.completedFuture(resolved), Exception.class);
        return result;
    }

    public static <T, E extends Exception> FutureWithException<T, E> failed(E exception) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(exception);
        Class<?> exceptionClass = exception.getClass();
        return new FutureWithException(future, exceptionClass);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    public T get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(timeout, unit);
    }

    public T getWithException() throws InterruptedException, E {
        try {
            return this.get();
        }
        catch (ExecutionException e) {
            return this.handleExecutionException(e);
        }
    }

    public T getWithException(long timeout, @NonNull TimeUnit unit) throws InterruptedException, E, TimeoutException {
        try {
            return this.get(timeout, unit);
        }
        catch (ExecutionException e) {
            return this.handleExecutionException(e);
        }
    }

    private T handleExecutionException(ExecutionException e) throws E {
        Throwable cause = e.getCause();
        if (this.expectedException.isInstance(cause)) {
            throw (Exception)this.expectedException.cast(cause);
        }
        throw new RuntimeException("Unexpected Exception thrown", cause);
    }

    public <S> FutureWithException<S, E> then(final FunctionWithException<T, S, E> transformer) {
        return new FutureWithException<T, E>(new Future<S>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return FutureWithException.this.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return FutureWithException.this.isCancelled();
            }

            @Override
            public boolean isDone() {
                return FutureWithException.this.isDone();
            }

            @Override
            public S get() throws InterruptedException, ExecutionException {
                try {
                    return transformer.apply(FutureWithException.this.get());
                }
                catch (InterruptedException | RuntimeException | ExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }

            @Override
            public S get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                try {
                    return transformer.apply(FutureWithException.this.get(timeout, unit));
                }
                catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }
        }, this.expectedException);
    }
}

