/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.date;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.locks.StampedLock;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jetbrains.annotations.VisibleForTesting;

class ClockProvider {
    private static final String NOW_SYSTEM_PROPERTY_NAME = "org.conqat.lib.commons.date.now";
    private static final String NOW_SYSTEM_PROPERTY_PATTERN = "yyyyMMddHHmmss";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private final StampedLock lock = new StampedLock();
    private @Nullable Clock clock;

    static ClockProvider getInstance() {
        return Singleton.INSTANCE.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clock getClock() {
        long stamp = this.lock.readLock();
        try {
            while (this.clock == null) {
                long tmpStamp = this.lock.tryConvertToWriteLock(stamp);
                if (tmpStamp != 0L) {
                    stamp = tmpStamp;
                    this.clock = ClockProvider.resolveClock();
                    break;
                }
                this.lock.unlockRead(stamp);
                stamp = this.lock.writeLock();
            }
            Clock clock = this.clock;
            return clock;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClock(@Nullable Clock clock) {
        long stamp = this.lock.writeLock();
        try {
            this.clock = clock;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public void resetClock() {
        this.setClock(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateClock(UnaryOperator<Clock> operator) {
        CCSMAssert.isNotNull(operator, () -> String.format("Expected \"%s\" to be not null", "operator"));
        long stamp = this.lock.writeLock();
        try {
            Clock tmp = this.clock;
            if (tmp == null) {
                tmp = ClockProvider.resolveClock();
            }
            this.clock = tmp = (Clock)operator.apply(tmp);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private static Clock resolveClock() {
        String nowProperty = System.getProperty(NOW_SYSTEM_PROPERTY_NAME);
        if (nowProperty == null) {
            return Clock.systemDefaultZone();
        }
        LocalDateTime dateTime = LocalDateTime.parse(nowProperty, FORMATTER);
        return Clock.fixed(dateTime.atZone(ZoneId.systemDefault()).toInstant(), ZoneId.systemDefault());
    }

    private ClockProvider() {
    }

    private static enum Singleton {
        INSTANCE(new ClockProvider());

        private final ClockProvider instance;

        private Singleton(ClockProvider instance) {
            this.instance = instance;
        }
    }
}

