/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.enums;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class EnumUtils {
    public static <T extends Enum<T>> @Nullable T valueOf(Class<T> enumType, String constantName) {
        try {
            T constant = Enum.valueOf(enumType, constantName);
            return constant;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <T extends Enum<T>> EnumSet<T> valuesOf(Class<T> enumType, Collection<String> constantNames) {
        EnumSet<T> result = EnumSet.noneOf(enumType);
        for (String constant : constantNames) {
            result.add(Enum.valueOf(enumType, constant));
        }
        return result;
    }

    public static <T extends Enum<T>> @Nullable T valueOfIgnoreCase(Class<T> enumType, String constantName) {
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        CCSMAssert.isNotNull(constants);
        for (Enum constant : constants) {
            if (!constant.name().equalsIgnoreCase(constantName)) continue;
            return (T)constant;
        }
        return null;
    }

    public static <T extends Enum<T>> String[] names(Class<T> enumType) {
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        CCSMAssert.isNotNull(constants);
        String[] result = new String[constants.length];
        for (int i = 0; i < constants.length; ++i) {
            result[i] = constants[i].name();
        }
        return result;
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumSet<T> mergeSets(Set<T> set, T ... values) {
        EnumSet<T> newSet = EnumSet.copyOf(set);
        newSet.addAll(Arrays.asList(values));
        return newSet;
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumSet<T> copyOfExcept(Set<T> set, T ... values) {
        EnumSet<T> newSet = EnumSet.copyOf(set);
        CollectionUtils.removeAll(newSet, Arrays.asList(values));
        return newSet;
    }

    public static <T extends Enum<T>> EnumSet<T> safeCopyOf(Collection<T> collection, Class<T> enumClass) {
        if (collection.isEmpty()) {
            return EnumSet.noneOf(enumClass);
        }
        return EnumSet.copyOf(collection);
    }

    private EnumUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

