/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.conqat.lib.commons.filesystem.DirectoryContentProvider;
import org.conqat.lib.commons.filesystem.ZipContentProvider;
import org.conqat.lib.commons.filesystem.ZipFile;

public abstract class PathBasedContentProviderBase
implements Closeable {
    public abstract Collection<String> getPaths() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract InputStream openStream(String var1) throws IOException;

    public Collection<String> getPathsWithPrefix(String prefix) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (String path : this.getPaths()) {
            if (!path.startsWith(prefix)) continue;
            result.add(path);
        }
        return result;
    }

    public static PathBasedContentProviderBase createProvider(File file) throws IOException {
        if (file.isDirectory()) {
            return new DirectoryContentProvider(file);
        }
        return new ZipContentProvider(new ZipFile(file));
    }
}

