/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Objects;
import org.rocksdb.AbstractCompactRangeCompletedCb;
import org.rocksdb.RocksObject;

public class CompactRangeOptions
extends RocksObject {
    private static final byte VALUE_kSkip = 0;
    private static final byte VALUE_kIfHaveCompactionFilter = 1;
    private static final byte VALUE_kForce = 2;
    private static final byte VALUE_kForceOptimized = 3;

    public CompactRangeOptions() {
        super(CompactRangeOptions.newCompactRangeOptions());
    }

    public boolean exclusiveManualCompaction() {
        return this.exclusiveManualCompaction(this.nativeHandle_);
    }

    public CompactRangeOptions setExclusiveManualCompaction(boolean exclusiveCompaction) {
        this.setExclusiveManualCompaction(this.nativeHandle_, exclusiveCompaction);
        return this;
    }

    public boolean changeLevel() {
        return this.changeLevel(this.nativeHandle_);
    }

    public CompactRangeOptions setChangeLevel(boolean changeLevel) {
        this.setChangeLevel(this.nativeHandle_, changeLevel);
        return this;
    }

    public int targetLevel() {
        return this.targetLevel(this.nativeHandle_);
    }

    public CompactRangeOptions setTargetLevel(int targetLevel) {
        this.setTargetLevel(this.nativeHandle_, targetLevel);
        return this;
    }

    public int targetPathId() {
        return this.targetPathId(this.nativeHandle_);
    }

    public CompactRangeOptions setTargetPathId(int targetPathId) {
        this.setTargetPathId(this.nativeHandle_, targetPathId);
        return this;
    }

    public BottommostLevelCompaction bottommostLevelCompaction() {
        return BottommostLevelCompaction.fromRocksId(this.bottommostLevelCompaction(this.nativeHandle_));
    }

    public CompactRangeOptions setBottommostLevelCompaction(BottommostLevelCompaction bottommostLevelCompaction) {
        this.setBottommostLevelCompaction(this.nativeHandle_, bottommostLevelCompaction.getValue());
        return this;
    }

    public boolean allowWriteStall() {
        return this.allowWriteStall(this.nativeHandle_);
    }

    public CompactRangeOptions setAllowWriteStall(boolean allowWriteStall) {
        this.setAllowWriteStall(this.nativeHandle_, allowWriteStall);
        return this;
    }

    public int maxSubcompactions() {
        return this.maxSubcompactions(this.nativeHandle_);
    }

    public CompactRangeOptions setMaxSubcompactions(int maxSubcompactions) {
        this.setMaxSubcompactions(this.nativeHandle_, maxSubcompactions);
        return this;
    }

    public CompactRangeOptions setFullHistoryTSLow(Timestamp tsLow) {
        this.setFullHistoryTSLow(this.nativeHandle_, tsLow.start, tsLow.range);
        return this;
    }

    public Timestamp fullHistoryTSLow() {
        return this.fullHistoryTSLow(this.nativeHandle_);
    }

    public CompactRangeOptions setCanceled(boolean canceled) {
        this.setCanceled(this.nativeHandle_, canceled);
        return this;
    }

    public boolean canceled() {
        return this.canceled(this.nativeHandle_);
    }

    private static native long newCompactRangeOptions();

    public CompactRangeOptions setAsyncCompletionCb(AbstractCompactRangeCompletedCb completionCb) {
        assert (this.isOwningHandle());
        this.setAsyncCompletionCb(this.nativeHandle_, completionCb.nativeHandle_);
        return this;
    }

    @Override
    protected final native void disposeInternal(long var1);

    private native boolean exclusiveManualCompaction(long var1);

    private native void setExclusiveManualCompaction(long var1, boolean var3);

    private native boolean changeLevel(long var1);

    private native void setChangeLevel(long var1, boolean var3);

    private native int targetLevel(long var1);

    private native void setTargetLevel(long var1, int var3);

    private native int targetPathId(long var1);

    private native void setTargetPathId(long var1, int var3);

    private native int bottommostLevelCompaction(long var1);

    private native void setBottommostLevelCompaction(long var1, int var3);

    private native boolean allowWriteStall(long var1);

    private native void setAllowWriteStall(long var1, boolean var3);

    private native void setMaxSubcompactions(long var1, int var3);

    private native int maxSubcompactions(long var1);

    private native void setFullHistoryTSLow(long var1, long var3, long var5);

    private native Timestamp fullHistoryTSLow(long var1);

    private native void setCanceled(long var1, boolean var3);

    private native boolean canceled(long var1);

    private native void setAsyncCompletionCb(long var1, long var3);

    public static class Timestamp {
        public final long start;
        public final long range;

        public Timestamp(long start, long duration) {
            this.start = start;
            this.range = duration;
        }

        public Timestamp() {
            this.start = 0L;
            this.range = 0L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Timestamp timestamp = (Timestamp)o;
            return this.start == timestamp.start && this.range == timestamp.range;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.range);
        }
    }

    public static enum BottommostLevelCompaction {
        kSkip(0),
        kIfHaveCompactionFilter(1),
        kForce(2),
        kForceOptimized(3);

        private final byte value;

        private BottommostLevelCompaction(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static BottommostLevelCompaction fromRocksId(int bottommostLevelCompaction) {
            switch (bottommostLevelCompaction) {
                case 0: {
                    return kSkip;
                }
                case 1: {
                    return kIfHaveCompactionFilter;
                }
                case 2: {
                    return kForce;
                }
                case 3: {
                    return kForceOptimized;
                }
            }
            return null;
        }
    }
}

