/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ELanguage;
import java.util.EnumMap;
import java.util.Map;
import org.conqat.engine.sourcecode.coverage.volume.condition.CLikeConditionEvaluator;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionEvaluatorBase;
import org.conqat.engine.sourcecode.coverage.volume.condition.JSConditionEvaluator;
import org.conqat.engine.sourcecode.coverage.volume.condition.PythonConditionEvaluator;

public class ConditionEvaluatorFactory {
    private static final Map<ELanguage, ConditionEvaluatorBase> CONDITION_EVALUATORS = new EnumMap<ELanguage, ConditionEvaluatorBase>(ELanguage.class);

    private static void registerLanguage(ELanguage language, ConditionEvaluatorBase conditionEvaluator) {
        CONDITION_EVALUATORS.put(language, conditionEvaluator);
    }

    public static ConditionEvaluatorBase createConditionEvaluator(ELanguage language) {
        return CONDITION_EVALUATORS.get(language);
    }

    public static boolean supportsLanguage(ELanguage language) {
        return CONDITION_EVALUATORS.containsKey(language);
    }

    static {
        ConditionEvaluatorFactory.registerLanguage(ELanguage.JAVA, new CLikeConditionEvaluator(ELanguage.JAVA));
        ConditionEvaluatorFactory.registerLanguage(ELanguage.CPP, new CLikeConditionEvaluator(ELanguage.CPP));
        ConditionEvaluatorFactory.registerLanguage(ELanguage.CPP_MS_CLI, new CLikeConditionEvaluator(ELanguage.CPP_MS_CLI));
        ConditionEvaluatorFactory.registerLanguage(ELanguage.C, new CLikeConditionEvaluator(ELanguage.C));
        ConditionEvaluatorFactory.registerLanguage(ELanguage.CS, new CLikeConditionEvaluator(ELanguage.CS));
        ConditionEvaluatorFactory.registerLanguage(ELanguage.JAVASCRIPT, new JSConditionEvaluator());
        ConditionEvaluatorFactory.registerLanguage(ELanguage.PYTHON, new PythonConditionEvaluator());
    }
}

