# Description
Checks that each line contains only a single statement.

# Extended Information
Does not report empty statements, use rule `empty_statement` for detecting empty statements.

Does not report anything for chained statements.

https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#no-more-than-one-statement-per-line
https://docs.abapopenchecks.org/checks/11/

# Examples
**Bad example**
```abap
WRITE foo. WRITE bar.
```

**Good example**
```abap
WRITE foo.
WRITE bar.
```

# Clean ABAP Code Style Guide
```ABAP
DATA do_this TYPE i.
do_this = input + 3.
```

Even if some occurrences may trick you into the misconception that this was readable:

```ABAP
" anti-pattern
DATA do_this TYPE i. do_this = input + 3.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/max_one_statement) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
