
**DON'T** put any logic in `createState()`.

Implementations of  `createState()` should return a new instance
of a State object and do nothing more.  Since state access is preferred 
via the `widget` field,  passing data to `State` objects using custom
constructor parameters should also be avoided and so further, the State
constructor is required to be passed no arguments.

**BAD:**
```dart
MyState global;

class MyStateful extends StatefulWidget {
  @override
  MyState createState() {
    global = MyState();
    return global;
  } 
}
```

```dart
class MyStateful extends StatefulWidget {
  @override
  MyState createState() => MyState()..field = 42;
}
```

```dart
class MyStateful extends StatefulWidget {
  @override
  MyState createState() => MyState(42);
}
```


**GOOD:**
```dart
class MyStateful extends StatefulWidget {
  @override
  MyState createState() {
    return MyState();
  }
}
```