
**PREFER** `x.isNotEmpty` to `!x.isEmpty` for `Iterable` and `Map` instances.

When testing whether an iterable or map is empty, prefer `isNotEmpty` over
`!isEmpty` to improve code readability.

**BAD:**
```dart
if (!sources.isEmpty) {
  process(sources);
}
```

**GOOD:**
```dart
if (todo.isNotEmpty) {
  sendResults(request, todo.isEmpty);
}
```
