Ensures following best practices for i18n. Checks for missing i18n attributes on elements and attributes containing texts. Can also check for texts without i18n attribute, elements that do not use custom ID (@@) feature and duplicate custom IDs

- Type: suggestion
- 🔧 Supports autofix (`--fix`)

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<div tooltip="This requires translation"></div>
     ~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div>
  <span>test{{data_from_backend}}</span>
        ~~~~~~~~~~~~~~~~~~~~~~~~~
</div>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{ value, plural, =0 {<div>No elements</div>} =1 {111} }
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div>
  <ng-container>Some text&nbsp;t&#64; tr1nslate</ng-container>
                ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
</div>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<p>Lorem ipsum <em i18n="@@dolor">dolor</em> sit amet.</p>
   ~~~~~~~~~~~~                              ~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div tooltip="This requires translation" i18n-tooltip></div>
     ~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div>
  <span i18n label="label is ignored in 'ignoreAttributes'">
  ~
    Missing custom ID
  </span>
        ~
</div>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div
  i18n-tooltip="@@custom-id"
  tooltip="This requires translation"
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  label="Custom label"
  ~~~~~~~~~~~~~~~~~~~~
  i18n-label="@@custom-id"
></div>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<h3 i18n="@@myId">Hello</h3>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~
<p i18n="@@myId">Good bye</p>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div i18n-tooltip="@@custom-id" tooltip="This requires translation">
                                ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  <span i18n="@@custom-id">Some text to translate</span>
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
</div>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div i18n-tooltip="@@custom-id" tooltip="This requires translation">
                                ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  <span i18n="@@custom-id">Some text to translate</span>
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
</div>
<div i18n-label="@@custom-id" label="A label"></div>
                              ~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div
  tooltip="This requires translation"
  ~~~~~~~
  i18n-placeholder
  placeholder="More translation, please"
  ~~~~~~~~~~~
  class="red"
>
  <div
    *ngIf="true"
    width="100px"
    label="Templates need translation too."
    ~~~~~
  >
    <span i18n label="label is ignored in 'ignoreAttributes'">
    ~
      Missing custom ID
    </span>
          ~
  </div>
  <ng-template i18n="@@template">
    <div>test{{binding}}</div>
  </ng-template>
</div>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<h1 i18n>Hello</h1>
~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<h1 i18n="@@custom-id">Hello</h1>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<span i18n="A balloon that displays data" data-balloon="Translated title" i18n-data-balloon>
                                          ~~~~~~~~~~~~
  Hello
</span>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<h1 i18n="Title of the sample@@custom-id" i18n-title="@@title-id" title="Translated title">
                                                                  ~~~~~
  Hello
</h1>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<img [src]="logo" i18n-title title="App Logo" i18n-alt="App logo" alt="App Logo"/>
                             ~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<h1 i18n>Hello</h1>
~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<h1 i18n="An introduction header for this sample">Hello</h1>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<h1 i18n="An introduction header for this sample@@custom-id">Hello</h1>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<h1 i18n="|An introduction header for this sample">Hello</h1>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-template>No people or teams matched your search</ng-template>
             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{ value, plural, =0 {<ng-template>No elements</ng-template>} =1 {111} }
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div>
  <ng-template>Some text&nbsp;t&#64; tr1nslate</ng-template>
               ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
</div>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-template>Lorem ipsum <ng-template i18n="@@dolor">dolor</ng-template> sit amet.</ng-template>
             ~~~~~~~~~~~~                                                ~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-template i18n>
~
  The author is {gender, select, male {male} female {female} other {other}}
</ng-template>
             ~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<h3 i18n="@@myId">Hello</h3>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~
<ng-template i18n="@@myId">Good bye</ng-template>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<div>
  <span i18n="@@custom-id">Some text to translate</span>
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div>
  <span class="red" i18n="@@custom-id">
    Some text to translate
  </span>
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div tooltip="This tooltip property is ignored">
  <span i18n>Some text to translate</span>
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div i18n-tooltip="@@tooltip.label" tooltip="This tooltip property is ignored">
  <span>Some text to translate</span>
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div i18n-tooltip="@@tooltip.label" tooltip="This tooltip property is ignored">
  <mat-icon>valid</mat-icon>
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div>-{{data_from_backend}}</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div>1{{data_from_backend}}</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div>-1{{data_from_backend}}</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div>
  My company untranslatable name{{data_from_backend}}
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<my-component size="s"></my-component>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<p i18n="@@customId">Lorem ipsum <em>dolor</em> sit amet.</p>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<a
  mat-button
  ngClass="class"
  routerLink="exclusions"
  i18n="@@keywording.tools.exclusions"
>
  Exclusions
</a>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<a
  mat-button
  routerLink="exclusions"
  i18n="@@keywording.tools.exclusions"
>
  Exclusions
</a>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-template #errorMessage>
  {{ error.title }}
</ng-template>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-container i18n="@@description">
  { value, plural, =0 {<div>No elements</div>} =1 {111} }
</ng-container>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span i18n>
  The author is {gender, select, male {male} female {female} other {other}}
</span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<mat-option *ngFor="let mode of modes" [value]="mode.id" i18n="@@option">
  {mode.name, select, mode {mode} other { {{mode.name}} } }
</mat-option>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-container ngProjectAs="top">&ngsp;</ng-container>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<p [ngPlural]="components">
  <ng-template ngPluralCase="1">1 component removed</ng-template>
  <ng-template ngPluralCase="1">{{components}} components removed</ng-template>
</p>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div tooltip="This requires translation"></div>
<div>
  <span i18n label="valid with i18n">Some text to translate</span>
</div>
<div tooltip="This requires translation" i18n-tooltip></div>
<div>
  <ng-container>Some text&nbsp;t&#64; tr1nslate</ng-container>
</div>
<div>
  <span>-{{data_from_backend}}</span>
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div label="1">
  <div matBadge="&#8288;">5</div>
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div ariaselected="0"></div>
<div>+</div>
<span>&nbsp;</span>
<span>123</span>
<ng-content select=".content-area"></ng-content>
<ul i18n="@@list">
  <li>ItemA</li>
  <li>ItemB</li>
  <li>ItemC</li>
</ul>
 <ng-template i18n="@@asd">
  <div>ItemA</div>
  <div>ItemB</div>
  <div>ItemC</div>
</ng-template>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<h1 i18n="An introduction header for this sample">Hello i18n!</h1>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<h1 i18n="An introduction header for this sample@@custom-id">Hello i18n!</h1>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<h1 i18n="An introduction header for this sample" i18n-title="Title of the sample" title="Translated title">
  Hello i18n!
</h1>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<h1 i18n="An introduction header for this sample@@custom-id" i18n-title="Title of the sample@@title-id" title="Translated title">
  Hello i18n!
</h1>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<img
  [src]="logo"
  i18n-title="Logo for the app"
  title="App Logo"
  i18n-alt="Translated alt logo"
  alt="Alternate logo"
/>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span i18n="@@custom-id">Some text to translate</span>
<span i18n="@@custom-id">Some text to translate</span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<h1 i18n="site header|An introduction header for this sample">Hello i18n!</h1>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<h1 i18n="site header|">Hello i18n!</h1>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<h1 i18n="site header|@@custom-id">Hello i18n!</h1>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-template>Let's ignore "ng-template"</ng-template>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-template
  [ngIf]="userGroups?.length > 0"
  [ngIfElse]="noTeamsTmpl"
  i18n="@@cu-user-list__no-matching-users-groups"
>
  No people or teams matched your search
</ng-template>
<ng-template i18n="@@cu-user-list__no-matching-users" #noTeamsTmpl>
  No people matched your search
</ng-template>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-template i18n="@@test">
  Text{{ Bound }}
</ng-template>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-template i18n="@@icu">
  Updated: {minutes, plural, =0 {just now} =1 {one minute ago} other
  {{{minutes}} minutes ago by {gender, select, male {male} female {female} other
  {other}}}}
</ng-template>
```

</details>
