The use of "$any" nullifies the compile-time benefits of Angular's type system

- Type: suggestion

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
{{ $any(framework).name }}
   ~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{{ this.$any(framework).name }}
   ~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<a [href]="$any(getHref())">Click here</a>
           ~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{{ $any(framework).name }}
   ~~~~~~~~~~~~~~~
<div>
  {{ this.$any(framework).name }}
     ~~~~~~~~~~~~~~~~~~~~
</div>
<a [href]="$any(getHref())">Click here</a>'
           ~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
{{ $any }}
```

<br>

---

<br>

#### ✅ Valid Code

```html
{{ obj.$any() }}
```

<br>

---

<br>

#### ✅ Valid Code

```html
{{ obj?.x?.y!.z!.$any() }}
```

<br>

---

<br>

#### ✅ Valid Code

```html
<a [href]="$test()">Click here</a>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button type="button" (click)="anyClick()">Click here</button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
{{ $any }}
{{ obj?.x?.y!.z!.$any() }}
<a [href]="$test()">Click here</a>
<button type="button" (click)="anyClick()">Click here</button>
```

</details>
